#ifndef _ROAD_H_
#define _ROAD_H_

#include "mbed.h"
#include "AccCar.h"

#define MAX_CARS 5

class AccCar;
class Road;

class Road {
public:
    EventFlags go_flags;
    EventFlags done_flags;
    int active_cars;
    int intersection_car;
    int wait_counter; 
    static Road* road_in_use(Road* new_road);
    static int ready(int new_ready);
    
    Road();
    int try_enter_car(int time);
    void let_cars_update();
    void wait_for_car_update();
    int check_exit_cars(int cars[]);
    void update_car_speed(int id, int speed);
    void update_wait_counter(); 
    
    void print_status();
    void publish_car_info();
    void wait_for_sync();
    
    
private:
    AccCar* last_car;
    AccCar* cars[MAX_CARS];
    
    AccCar* pending_car;
    int next_release;
    int num_cars;
};
#endif