/* mbed Microcontroller Library
 * Copyright (c) 2018 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "Road.h"
#include "AccCar.h"
#include "TextLCD.h"
#include "Intersection.h" 

TextLCD lcd(p15, p16, p17, p18, p19, p20);

// main() runs in its own thread in the OS
int main() {
    // ------------------------------------------------------------------------------
    // The following three variables are used for timing statistics, do not modify them
    Timer stopwatch;    // A timer to keep track of how long the updates take, for statistics purposes
    int numberCycles = 0;
    int totalUpdateTime = 0;
    int road1wait = 0;
    int road2wait = 0;
    // ------------------------------------------------------------------------------

    int time = 0;

    Intersection intersection; 
    Road* road1 = new Road(&intersection, 1);
    Road* road2 = new Road(&intersection, 2); 

    stopwatch.start();
    stopwatch.reset();
    
    
    do {
        intersection.preChecks(); 
        if (intersection.queue[0] > -1) {
            if (intersection.queue[0] < 5) {
                road1wait++;
            } else {
                road2wait++;
            }
        }
        if (intersection.queue[1] > -1) {
            if (intersection.queue[1] < 5) {
                road1wait++;
            } else {
                road2wait++;
            }
        }
        
        int new_cars1 = road1->try_enter_car(time);
        int new_cars2 = road2->try_enter_car(time); 
        
        road1->let_cars_update();
        road2->let_cars_update(); 
        road1->wait_for_car_update();
        road2->wait_for_car_update(); 
        
        
        printf("\r\nRoad 1 Update %d\r\n", time);
        road1->print_status();
        printf("\r\nRoad 2 Update %d\r\n", time);
        road2->print_status(); 
    
    lcd.cls(); 
    if(new_cars1 == -1 && (intersection.intersection_car == -1 || intersection.intersection_car > 4)){
            lcd.printf("x, x\n");
    }
    else if(new_cars1 != -1 && (intersection.intersection_car == -1 || intersection.intersection_car > 4)){
        lcd.printf("%d, x\n", new_cars1);
    }
    else if(new_cars1 == -1 && !(intersection.intersection_car == -1 || intersection.intersection_car > 4)){
        lcd.printf("x, %d\n", intersection.intersection_car);
    }
    else{
        lcd.printf("%d, %d\n", new_cars1, intersection.intersection_car);
    }
    
    if(new_cars2 == -1 && intersection.intersection_car < 5){
        lcd.printf("x, x");
    }
    else if(new_cars2 != -1 && intersection.intersection_car < 5){
        lcd.printf("%d, x", new_cars2);
    }
    else if(new_cars2 == -1 && intersection.intersection_car >= 5){
        lcd.printf("x, %d", intersection.intersection_car);
    }
    else{
        lcd.printf("%d, %d", new_cars2, intersection.intersection_car);
    }

    printf("\r\n");
    road1->check_exit_cars();  
    road2->check_exit_cars(); 
    time++;
        
        // ------------------------------------------------------------------
        // Timing statistics logic, do not modify
        totalUpdateTime += stopwatch.read_ms();
        numberCycles++;
        stopwatch.reset();
        // ------------------------------------------------------------------
                
    } while( road1->active_cars > 0x00 || road2->active_cars > 0x00);
    
            // ----------------------------------------------------------------------
    // Timing statistics printout, do not modify
    printf("Average update cycle took: %fms \r\n", (totalUpdateTime*1.0)/(numberCycles*1.0));
    printf("Average road1 intersection wait: %fs \r\n", (road1wait*1.0)/5.0);
    printf("Average road2 intersection wait: %fs \r\n", (road2wait*1.0)/5.0);
    totalUpdateTime = 0;
    numberCycles = 0;
    // ----------------------------------------------------------------------
}
