#include "Intersection.h"
#include <stdlib.h>

Intersection::Intersection() {
    intersection_car = -1;
    queue[0] = -1; 
    queue[1] = -1; 
    occupied = false; 
    road1Car = -1; 
    road2Car = -1; 
}

void Intersection::preChecks() {
    if (intersection_car == -1) {
        occupied = false;
    }
    
    if (road1Car > -1) {
        if (queue[0] == -1) {
            queue[0] = road1Car; 
        } else {
            queue[1] = road1Car; 
        }
        road1Car = -1; 
    } 
    
    if (road2Car > -1) {
        if (queue[0] == -1) {
            queue[0] = road2Car; 
        } else {
            queue[1] = road2Car; 
        }
        road2Car = -1; 
    } 
}

void Intersection::intendToEnter(int carId, int roadId) {
    if (roadId == 1) {
        road1Car = carId; 
    } else {
        road2Car = carId; 
    }
}

void Intersection::leaveIntersection() {
    this->intersection_car = -1;
} 

int Intersection::attemptEnterIntersection(int carId) {
    if (occupied || queue[0] != carId) {
        return 0; 
    } else {
         intersection_car = carId; 
         occupied = true; 
         queue[0] = queue[1]; 
         queue[1] = -1; 
         return 1; 
    }
}

