/*Lectura de un termistor NTC y mostrar lectura en el puerto serial.
La lectura analogica se realiza cada 1.5s por medio de una
interrupcion
*/

#include "mbed.h"
#include <math.h>
Ticker tempo1;                          //Interrupcion para lectura del NTC

Serial hercules (PA_2,PA_3, 115200);    //configuracion de com serial
AnalogIn ain(PC_5);                     // pin para lectura del termistor
float vm=0;                             //variable con dato analogo proveniente del divisor

/////////Datos de fabrica del termistor////////////////////////////////////////
float Raux=100000.0;                                    // Resisrencia auxiliar para el divisor de voltaje
float vcc=3.34;                                         // voltaje del divisor de tension
float temp0 = 298.0;                                    //temperatua 24C en grados kelvin
float r0 = 100000.0;                                    //resistencia a los 24C
float Beta=3950.0;                                      //constante ntc OBTENIDO de la hoj de datos
float Rntc=0;
float tempC=0.0;
float temperaturaK = 0.0;
//////////DECLARACION DE FUNCIONES//////////////////////////////////////////
void TermistorRead();

int main()
{
    tempo1.attach(&TermistorRead, 1.5);             //caca 1.5 seg se ejecuta la lectura del termistor
    while(1) {
        hercules.printf("Temperatura: %2,2f\r\n");  //solo 2 decimales.
        wait (0.3);
    }
}

void TermistorRead()                                    //lectura de dato analogico proveniente del divisor de voltaje.
{
    vm=ain;                                             //Lectura analogica 
    vm*=3,3;                                            //Para convertir valor analogico a voltios
    Rntc= ((Raux*vcc)/vm)-Raux;                         //despejando Rntc la formula del divisor.
    temperaturaK =Beta/(log(Rntc/r0)+(Beta/temp0));     //formula para encontrar la temperatura
    tempC= temperaturaK - 273;                          //convertir kelvin a C
}