//PROYECTO FINAL DE FIN DE CURSO
//CONTROL DE TEMPERATURA DE UN CAUTIN MEDIANTE EL USO DE ALGORITMOS PID
//SE INGRESA EL SETPOINT DE TEMPERATURA DESDE UN TECLADO MATRICIAL Y SE MOSTRARA EN UN DISPLAY DE 7SEG LA TEMP REAL


//////////INCLUSION DE LIBRERIAS////////////////////////////////////////////////
#include "mbed.h"
#include "keypad.h"                                 //se incluye libreria del teclado 4x4
#include "TextLCD.h"                                //Libreria para el lcd
#include <math.h>
#include <iostream>
#include <string>
#include <sstream>

////////////////////////////////////////////////////////////////////////////////

//////////TIMERS////////////////////////////////////////////////////////////////
Ticker tempo1;                                       //Tiempo para lectura del termistor
Timer Rele;

//////////CONFIGURACION PUERTO SERIE///////////////////////////////////////////
Serial hercules (PA_2,PA_3, 115200);                //define pines para com serial
///////////////////////////////////////////////////////////////////////////////

/////////CONFIGRACION DE PINES DEL LCD////////////////////////////////////////////////////
TextLCD lcd(PC_2, PE_12, PE_14, PB_13, PB_14, PB_15);    // rs, e, d4-d7 pines para el lcd 16x2
////////////////////////////////////////////////////////////////////////////////

/////////CONFIGRACION PUERTO ANALOGICO//////////////////////////////////////////
AnalogIn ain(PC_5);                                 // pin para lectura del termistor
float vm=0;                                    //variable con dato analogo proveniente del divisor

////////////////////////////////////////////////////////////////////////////////

/////////Datos de fabrica del termistor////////////////////////////////////////
float Raux=100000.0;                                     // Resisrencia auxiliar para el divisor de voltaje
float vcc=3.34;                                          // voltaje del divisor de tension
float temp0 = 298.0;                                    //temperatua 24C en grados kelvin
float r0 = 100000.0;                                    //resistencia a los 24C
float Beta=3950.0;                                      //constante ntc OBTENIDO de la hoj de datos
float Rntc=0;
float tempC=0.0;
float temperaturaK = 0.0;
////////////////////////////////////////////////////////////////////////////////

////////////CONFIGURACION DE TECLADO /////////////
char key;                                                 //variable para almacenar la tecla pulsada
//  c0   c1    c2    c3   r0   r1    r2    r3
//define pines para el teclado
//  c0   c1   c2   c3  r0   r1   r2   r3
Keypad keypad(PD_7,PC_8,PD_6,PB_0,PC_9,PA_8,PC_6,PC_7 );

/////////////////////////////////////////////////

char setpoint;

int numero;
int unidad;
int decena;
int centena;
int total; //valor de setpoint para pid
int i=0;


DigitalOut RLY(PB_1);       //Rele de estado solido para activar el cautin.
DigitalOut Bled(PD_15);    //LED AZUL
DigitalOut Rled(PD_14);    //LED ROJO

///////////DECLARACION DE FUNCIONES////////////////////////////////////////////
void TermistorRead();
void lcd_16x2();
void asiganacion();
void Calentador();
void menu();


int main()
{
    keypad.enablePullUp();
    //Rele.start(); //da inicio al TIMER RELE.
    tempo1.attach(&TermistorRead, 1.5); //caca 1.5 seg se ejecuta la lectura del termistor
    while(1) {
        //if (Rele.read_ms()>=1000) { // read time in ms
        //   Calentador(); // call tarea function
        //   Rele.reset(); // reset timer
        //}
        //teclado();
        key = keypad.getKey();
        if(key != KEY_RELEASED) {
            wait(0.6);
        }
        if (key=='A') {
            menu();
        }
        lcd_16x2();
        menu();
        RLY =! RLY;
        wait(0.3);
    }//WHILE
}//MAIN


//////////////////////FUNCIONES////////////////////////////////////////////////

void TermistorRead()  //lectura de dato analogico proveniente del divisor de voltaje.
{
    vm=ain;
    vm*=3,3;
    Rntc= ((Raux*vcc)/vm)-Raux; //despejando Rntc la formula del divisor.
    temperaturaK =Beta/(log(Rntc/r0)+(Beta/temp0));     //formula para encontrar la temperatura
    tempC= temperaturaK - 273;                          //convertir kelvin a C
    Bled =! Bled;
}

void lcd_16x2()
{
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("%.0f",tempC);                       // solo muestra la partedecimal
}

void menu()
{
    if (key=='A') {
        for(i=0; i<3; i++) {
            if (i==0) {
                hercules.printf("ingrese SetPoint\r\n");
                asiganacion();
                unidad =numero*1;
                hercules.printf("%d\r\n",unidad);
            }

            if (i==1) {
                hercules.printf("ingrese 2da tecla\r\n");
                asiganacion();
                decena =numero*10;
                hercules.printf("%d\r\n",decena);
            }

            if (i==2) {
                hercules.printf("ingrese 3era tecla\r\n");
                asiganacion();
                centena =numero*100;
                hercules.printf("%3d\r\n",centena);
            }
            if (key == 'B') {   //sale del ciclo si se pulsa B
                hercules.printf("Exit");
                main();
            }
        }
        wait(0.1);
        total=unidad+decena+centena;
        hercules.printf("%d",total);
    }
}


void asiganacion ()
{

    do {
        key = keypad.getKey();
        if(key != KEY_RELEASED) {
            wait(0.6);
        }
    } while (key ==0x00);
    
    if(key == '0') numero=0;
    if(key == '1') numero=1;
    if(key == '2') numero=2;
    if(key == '3') numero=3;
    if(key == '4') numero=4;
    if(key == '5') numero=5;
    if(key == '6') numero=6;
    if(key == '7') numero=7;
    if(key == '8') numero=8;
    if(key == '9') numero=9;

}


void Calentador()
{
    RLY = !RLY;
}








