#include "mbed.h"
#include "ReceiverIR.h"
#include "Motor.h"
#include "TextLCD.h"

#ifndef GLOBLVAR_H
#define GLOBLVAR_H

//The IR receiver
ReceiverIR ir_rx(p15);
//The output serial port
Serial pc(USBTX, USBRX);
DigitalOut leds[] = {(LED1), (LED2),(LED3), (LED4)};
//The force sensors
AnalogIn doorForce(p16);
AnalogIn wallForce(p20);
//The motor
Motor myMotor(p23,p6,p5);
//The LCD
TextLCD lcd(p24, p25, p26, p27, p28, p29, TextLCD::LCD20x4); // rs, e, d4-d7

bool newState=false;
bool held;
bool signal;
float force;
float wall;
float speed;
int speedPercent;

RemoteIR::Format format;
float pushSpeed;
float forceThresh;

//The states
enum RunState
{
    BOOT = 0,
    LISTEN,
    CLOSE_DOOR,
    CHECK_IR,
    CHECK_FORCE,
    CHECK_WALL,
    RUN_MOTOR,
    RESET,
};


RunState state = BOOT;

#endif