#include "globlvar.h"

//Put all variables that must be accessible to all functions here.

#ifndef DEFINE_H
#define DEFINE_H

#define PRINT(message)  pc.printf( (message) );

#define PRINTLN(message)    pc.printf( (message) );\
                            pc.printf("\n\r");
                            
#define LED(i)  leds[i]

#define LED_0 1
#define LED_1 2
#define LED_2 4
#define LED_3 8

#define CODE_ON 
#define FORWARD 1
#define BACKWARD -1


//OPTIONS

//Which side of the arm is the door
#define DIRECTION BACKWARD
//Minimum force to start pushing
#define FORCE_MIN .05
//Default value of the force threshold
#define DEFAULT_FORCE .4
//Default value for the speed
#define DEFAULT_SPEED 1
//Speed of the arm when not in contact with door
#define COAST_SPEED .3
//Speed of the arm when returning to wall
#define REVERSE_SPEED -0.4
//Force threshold for contact with wall
#define WALL_THRESH .05
//How long to push after contacting door
#define PUSH_TIME .5
//How much the speed changes with each button press
#define SPEED_INC 0.05f
//How much the force changes with each button press
#define FORCE_INC 0.1f



#define SPEED_MIN COAST_SPEED

//BUTTON DEFINITIONS
#define NONE -1
#define SPD_DN 2
#define SPD_UP 3
#define FRC_UP 0
#define FRC_DN 1
#define RUN 14
#define RST 69



#define SET_LEDS(mask, state)   LED(0) = ((mask)&1!=0); \
                                LED(1) = ((mask)&2!=0); \
                                LED(2) = ((mask)&4!=0); \
                                LED(0) = ((mask)&8!=0); 
#define ON  1
#define OFF 0


#endif