#include "mbed.h"
#include "func.h"
#include "define.h"
#include "globlvar.h"


int main()
{
    int myButton;
    //For developer use
    //GetIRCodes();
    //GetForces();
    format = RemoteIR::SONY;
    while(1) {
        //The state machine switch statement
        switch( state) {
            //The initialization state
            case BOOT:
                pc.printf("BOOTING UP\n\r");
                forceThresh = DEFAULT_FORCE;
                pushSpeed = DEFAULT_SPEED;
                state = LISTEN;
                newState = true;
                held = false;
                lcd.cls();
                lcd.printf("RON SWANSON \nDOOR SLAMMER!");
                break;
            //Listen for IR signal             
            case LISTEN:
                if(newState)
                    pc.printf("LISTENING FOR IR\n\r");
                newState = false;
                myButton = IRListen();

                switch(myButton) {
                    case NONE:
                        break;
                    case RUN:
                        pc.printf("OK Button\n\r");
                        state = CLOSE_DOOR;
                        newState = true;
                        held = true;
                        break;
                    case SPD_UP:
                        if(pushSpeed+SPEED_INC<=1)
                            pushSpeed += SPEED_INC;
                        else
                            pushSpeed = 1;
                        speedPercent = (int)(pushSpeed*100.0f);
                        lcd.cls();
                        lcd.printf("Speed:\n%3d%%\n\r", speedPercent);
                        pc.printf("Speed:\n%3d%%\n\r", speedPercent);
                        break;
                    case SPD_DN:
                        if(pushSpeed-SPEED_INC>=SPEED_MIN)
                            pushSpeed -= SPEED_INC;
                        else
                            pushSpeed = SPEED_MIN;
                        speedPercent = (int)(pushSpeed*100.0f);
                        lcd.cls();
                        lcd.printf("Speed:\n%3d%%\n\r", speedPercent);
                        pc.printf("Speed:\n%3d%%\n\r", speedPercent);
                        break;
                    case RST:
                        pc.printf("Exit Button\n\r");
                        state = BOOT;
                        break;
                    case FRC_UP:

                        if(forceThresh+FORCE_INC<=1)
                            forceThresh+=FORCE_INC;
                        lcd.cls();
                        lcd.printf("Force threshold:\n%f pounds\n", (forceThresh*200.0f)/4.44822162f);
                        pc.printf("Force threshold:\n\r%f pounds\n\r", (forceThresh*200.0f)/4.44822162f);
                        break;
                    case FRC_DN:
                        if(forceThresh-FORCE_INC>0)
                            forceThresh-=FORCE_INC;
                        lcd.cls();
                        lcd.printf("Force threshold:\n%f pounds\n", (forceThresh*200.0f)/4.44822162f);
                        pc.printf("Force threshold:\n\r%f pounds\n\r", (forceThresh*200.0f)/4.44822162f);
                        break;
                    default:
                        pc.printf("Unknown Button: %d\n\r", myButton);
                        break;
                }
                break;
            case CLOSE_DOOR:
                lcd.cls();
                lcd.printf("GET OUT\n");
                pc.printf("CLOSING DOOR\n\r");
                state = CHECK_IR;
                break;
            case CHECK_IR:
                pc.printf("CHECKING FOR CANCEL SIGNAL\n\r");
                if(IRListen()==-1)
                    held = false;
                else if(!held) {
                    pc.printf("CANCEL SIGNAL RECEIVED\n\r");
                    state = RESET;
                    break;
                }
                state = CHECK_FORCE;
                break;
            case CHECK_FORCE:
                force = doorForce;
                pc.printf("CHECKING FORCE: %f\n\r", force);
                if(force<FORCE_MIN)
                    speed = COAST_SPEED;
                else if(force<forceThresh)
                    speed = pushSpeed;
                else {
                    wait(PUSH_TIME);
                    state = RESET;
                    break;
                }
                state = RUN_MOTOR;
                pc.printf("\tNEW SPEED: %f\n\r", speed);
                break;
            case RUN_MOTOR:
                myMotor.speed(DIRECTION*speed);

                state = CHECK_IR;
                break;
            case RESET:
                pc.printf("RETURNING TO IDLE\n\r");
                myMotor.speed(0);
                myMotor.speed(DIRECTION*REVERSE_SPEED);
                state = CHECK_WALL;
                break;
            case CHECK_WALL:
                wall = wallForce;
                if(wall>=WALL_THRESH||IRListen()>=0) {
                    myMotor.speed(0);
                    state = LISTEN;
                    lcd.printf("AND STAY OUT!");
                    pc.printf("WALL DETECTED, ENTERING IDLE STATE\n\r");

                    break;
                }
                pc.printf("CHECKING WALL: %f\n\r", wall);

                break;
            default:
                break;
        }


    }
}

