#include "globlvar.h"
#ifndef FUNC_H
#define FUNC_H

//Function that checks the IR Receiver for a message, returning the first byte of the array, 
//which is a unioque between the buttons used by this device.
int IRListen()
{
    uint8_t buf[32];
    int bitcount = 0;
    if (ir_rx.getState() == ReceiverIR::Received) {
        bitcount = ir_rx.getData(&format, buf, sizeof(buf) * 8);
    } else {
        return -1;
    }
    if(bitcount > 0) {
        //for(int i = 0; i < bitcount; i++) {
            pc.printf("%d  ", buf[0]);
        //}
        pc.printf("\n\r");
        return buf[0];
    }
    return -1;

}
//Debugging application used to get the IR codes for each button press.
void GetIRCodes()
{
    while(1) {
        uint8_t buf[32];
        int bitcount = 0;
        if (ir_rx.getState() == ReceiverIR::Received) {
            bitcount = ir_rx.getData(&format, buf, sizeof(buf) * 8);
            if(bitcount > 0) {
                pc.printf("Bitcount: %d, sizeof(buf): %d\n\r", bitcount, sizeof(buf)*8);
                for(int i = 0; i < 32; i++) {
                    pc.printf("%d  ", buf[i]);
                }
                pc.printf("\n\r");
            }
        }
        wait(.1);
    }
}
//Debugging function that outputs the forces on each sensor.
void GetForces()
{
    while(1)
    {
        force = doorForce;
        wall = wallForce;
        lcd.printf("Door: %f\nWall: %f", force, wall);
        wait(.3);
    }
}   

#endif