/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "BufferedSerial.h" 
//#include "TextLCD.h"
#include "USBSerial.h"


//USBSerial usbSerial(0x1f00, 0x2012, 0x0001,  false);
USBSerial usbSerial;

DigitalOut led1(PB_4);
DigitalOut led2(PB_12);
DigitalOut BT_RST(PB_5);
DigitalIn button(PC_13);
DigitalOut Stby_can(PD_3);
DigitalOut re_3v3(PC_10);
DigitalOut re_5v(PB_10);
DigitalIn bt_state (PA_15);

DigitalIn in1 (PA_7);
DigitalIn in2 (PB_0);
DigitalIn in3 (PB_1);
DigitalIn in4 (PF_10);
DigitalIn in5 (PA_4);
DigitalIn in6 (PA_5);
DigitalIn in7 (PA_6);
DigitalIn in8 (PB_3);

//GPIO1 Puerto1
DigitalIn gpio1 (PD_6);
DigitalIn gpio2 (PD_7);
DigitalIn gpio3 (PB_11);
DigitalIn gpio4 (PF_14);
DigitalIn gpio5 (PD_15);
DigitalIn gpio6 (PE_15);
DigitalIn gpio7 (PD_12);

//GPIO1 Puerto2
DigitalIn gpio8 (PG_0);
DigitalIn gpio9 (PF_11);
DigitalIn gpio10 (PG_2);
DigitalIn gpio11 (PG_3);
DigitalIn gpio12 (PG_4);
DigitalIn gpio13 (PG_5);
DigitalIn gpio14 (PG_6);

//GPIO1 Puerto3
DigitalIn gpio15 (PE_0);
DigitalIn gpio16 (PG_8);
DigitalIn gpio17 (PE_1);
DigitalIn gpio18 (PG_10);
DigitalIn gpio19 (PG_11);
DigitalIn gpio20 (PG_12);
DigitalIn gpio21 (PE_3);


BufferedSerial RS232_2(PC_12, PE_7);
BufferedSerial RS232_1(PD_8, PD_9,1536, 1);
BufferedSerial RS485(PC_6, PC_7);
BufferedSerial BT(PA_9, PA_10,1536 ,1);
BufferedSerial TTL(PA_2, PA_3);
BufferedSerial vm(PA_0, PA_1);


DigitalOut OUT1(PB_13);  //Salidas activas en bajo
DigitalOut OUT2(PB_14);  //Salidas activas en bajo
DigitalOut OUT3(PB_15);  //Salidas activas en bajo
DigitalOut OUT4(PC_0);  //Salidas activas en bajo


// I2C Communication
//I2C i2c_lcd(PC_9,PA_8); // SDA, SCL  Nucleo F103RB Board
//TextLCD_I2C lcd(&i2c_lcd, 0x4E, TextLCD::LCD16x2, TextLCD::HD44780); // I2C bus, PCF8574 Slaveaddress, LCD Type, Device Type
//LCD Type possible for example: LCD16x2, LCD20x4
//!!Adress here is 0x4E normal adress 0x27, but thats the same, you have to shift left
//  Adress-shift:    0100 1110     <-   0010 0111 (0x27)

//AnalogIn ana_A0(A0);      //same as Pin PA_0


//////////////////////////////////////////////////////////////////////////////
int main()
{
  //  lcd.setMode(TextLCD::DispOn); //DispOff, DispOn
  //  lcd.setBacklight(TextLCD::LightOff);//LightOff, LightOn ->!LightOff->on!
  //  lcd.setCursor(TextLCD::CurOff_BlkOff);//CurOff_BlkOff, CurOn_BlkOff, CurOff_BlkOn, CurOn_BlkOn
    
    Stby_can = 0;
    led1 = 0;
    led2 = 0;
    BT_RST = 1;
    
    gpio1.mode(PullDown);
    gpio2.mode(PullDown);
    gpio3.mode(PullDown);
    gpio4.mode(PullDown);
    gpio5.mode(PullDown);
    gpio6.mode(PullDown);
    gpio7.mode(PullDown);
    
    gpio8.mode(PullDown);
    gpio9.mode(PullDown);
    gpio10.mode(PullDown);
    gpio11.mode(PullDown);
    gpio12.mode(PullDown);
    gpio13.mode(PullDown);
    gpio14.mode(PullDown);
    
    gpio15.mode(PullDown);
    gpio16.mode(PullDown);
    gpio17.mode(PullDown);
    gpio18.mode(PullDown);
    gpio19.mode(PullDown);
    gpio20.mode(PullDown);
    gpio21.mode(PullDown);
        
    char datoUSB[1311];
    char ONOUTS[] = "ONOUTS";
    char OFFOUTS[] = "OFFOUTS";
    char ONOUT1[] = "ONOUT1";
    char ONOUT2[] = "ONOUT2";
    char ONOUT3[] = "ONOUT3";
    char ONOUT4[] = "ONOUT4";
    char ANTO[] = "ANTO";   
    char ON3V3[]  =  "ON3V3";
    char OFF3V3[] = "OFF3V3";
    char RSTBT[] = "RSTBT";
    char ON5V[] = "ON5V";
    char OFF5V[] = "OFF5V";
    
    char datox;
    int x;
    int y = 0;
    int i = 0;
    
    BT.baud(9600);
    RS232_1.baud(115200);
    RS232_2.baud(115200);
    RS485.baud(115200);
    TTL.baud(115200);
    vm.baud(9600);
    wait_us(1000000);
    
    BT.printf("BT: Inicio\n");
    RS232_1.printf("RS232_1: Inicio\n");
    RS232_2.printf("RS232_1: Inicio\n");
    TTL.printf("TTL: Inicio\n");
    usbSerial.printf("USB: Inicio\n");
    
    re_3v3 = 0;
    re_5v = 0;
    x = 0;
    
    wait_us(1000000);
    
    //lcd.printf("Inicio\n" );   //   \n will produce newcolumn
    //lcd.printf("Test Guaria2\n" );       //   \n will produce newcolumn
    
 //////////////////////////////////////////////////////////////////////////////
 
    while (true) {
        
        x = 0;
        led1 = !led1;
        led2 = !led2;
        
        usbSerial.printf("USB: tx...\n");
        
        BT.printf("BT: Boton = %d, in1 = %d, in2 = %d , in3 = %d, in4 = %d, in5 = %d, in6 = %d, in7 = %d, in8 = %d \r\n",button.read(),in1.read(),in2.read(),in3.read(),in4.read(),
                                                                                                        in5.read(),in6.read(),in7.read(),in8.read()); 
        RS232_1.printf("RS232_1: Boton = %d, in1 = %d, in2 = %d , in3 = %d, in4 = %d, in5 = %d, in6 = %d, in7 = %d, in8 = %d \r\n",button.read(),in1.read(),in2.read(),in3.read(),in4.read(),
                                                                                                        in5.read(),in6.read(),in7.read(),in8.read()); 
        RS232_2.printf("RS232_2: Boton = %d, in1 = %d, in2 = %d , in3 = %d, in4 = %d, in5 = %d, in6 = %d, in7 = %d, in8 = %d \r\n",button.read(),in1.read(),in2.read(),in3.read(),in4.read(),
                                                                                                        in5.read(),in6.read(),in7.read(),in8.read());                                                                                                  
        TTL.printf("TTL: Boton = %d, in1 = %d, in2 = %d , in3 = %d, in4 = %d, in5 = %d, in6 = %d, in7 = %d, in8 = %d \r\n",button.read(),in1.read(),in2.read(),in3.read(),in4.read(),
                                                                                                        in5.read(),in6.read(),in7.read(),in8.read());                                                                                             
        RS485.printf("RS485: Boton = %d, in1 = %d, in2 = %d , in3 = %d, in4 = %d, in5 = %d, in6 = %d, in7 = %d, in8 = %d \r\n",button.read(),in1.read(),in2.read(),in3.read(),in4.read(),
                                                                                                        in5.read(),in6.read(),in7.read(),in8.read()); 
        //serial.printf("Test USB\r\n");
        BT.printf("BT: GPIOP1: %d%d%d%d%d%d%d, GPIOP2: %d%d%d%d%d%d%d, GPIOP3: %d%d%d%d%d%d%d\r\n",gpio7.read(),gpio6.read(),gpio5.read(),gpio4.read(),
                                                                                               gpio3.read(),gpio2.read(),gpio1.read(),
                                                                                               gpio14.read(),gpio13.read(),gpio12.read(),gpio11.read(),
                                                                                               gpio10.read(),gpio9.read(),gpio8.read(),
                                                                                               gpio21.read(),gpio20.read(),gpio19.read(),gpio18.read(),
                                                                                               gpio17.read(),gpio16.read(),gpio15.read());             
                                                                                                                                                                                   
        RS232_1.printf("RS232_1: GPIOP1: %d%d%d%d%d%d%d, GPIOP2: %d%d%d%d%d%d%d, GPIOP3: %d%d%d%d%d%d%d\r\n",gpio7.read(),gpio6.read(),gpio5.read(),gpio4.read(),
                                                                                               gpio3.read(),gpio2.read(),gpio1.read(),
                                                                                               gpio14.read(),gpio13.read(),gpio12.read(),gpio11.read(),
                                                                                               gpio10.read(),gpio9.read(),gpio8.read(),
                                                                                               gpio21.read(),gpio20.read(),gpio19.read(),gpio18.read(),
                                                                                               gpio17.read(),gpio16.read(),gpio15.read());             

        RS232_2.printf("RS232_2: GPIOP1: %d%d%d%d%d%d%d, GPIOP2: %d%d%d%d%d%d%d, GPIOP3: %d%d%d%d%d%d%d\r\n",gpio7.read(),gpio6.read(),gpio5.read(),gpio4.read(),
                                                                                               gpio3.read(),gpio2.read(),gpio1.read(),
                                                                                               gpio14.read(),gpio13.read(),gpio12.read(),gpio11.read(),
                                                                                               gpio10.read(),gpio9.read(),gpio8.read(),
                                                                                               gpio21.read(),gpio20.read(),gpio19.read(),gpio18.read(),
                                                                                               gpio17.read(),gpio16.read(),gpio15.read());             
 
        TTL.printf("TTL: GPIOP1: %d%d%d%d%d%d%d, GPIOP2: %d%d%d%d%d%d%d, GPIOP3: %d%d%d%d%d%d%d\r\n",gpio7.read(),gpio6.read(),gpio5.read(),gpio4.read(),
                                                                                               gpio3.read(),gpio2.read(),gpio1.read(),
                                                                                               gpio14.read(),gpio13.read(),gpio12.read(),gpio11.read(),
                                                                                               gpio10.read(),gpio9.read(),gpio8.read(),
                                                                                               gpio21.read(),gpio20.read(),gpio19.read(),gpio18.read(),
                                                                                               gpio17.read(),gpio16.read(),gpio15.read());                                                                                                                     

        RS485.printf("RS485: GPIOP1: %d%d%d%d%d%d%d, GPIOP2: %d%d%d%d%d%d%d, GPIOP3: %d%d%d%d%d%d%d\r\n",gpio7.read(),gpio6.read(),gpio5.read(),gpio4.read(),
                                                                                               gpio3.read(),gpio2.read(),gpio1.read(),
                                                                                               gpio14.read(),gpio13.read(),gpio12.read(),gpio11.read(),
                                                                                               gpio10.read(),gpio9.read(),gpio8.read(),
                                                                                               gpio21.read(),gpio20.read(),gpio19.read(),gpio18.read(),
                                                                                               gpio17.read(),gpio16.read(),gpio15.read()); 
                                                                                                                                                                
        if (((bt_state.read())==1)&&(y==0)){
            
            BT.printf("BT: Bluetooth Conectado\r\n");
            RS232_1.printf("RS232_1: Bluetooth Conectado\r\n");
            RS232_2.printf("RS232_2: Bluetooth Conectado\r\n");
            RS485.printf("RS485: Bluetooth Conectado\r\n");
            TTL.printf("TTL: Bluetooth Conectado\r\n");
            vm.putc(0XAA);
            vm.putc(0X07);
            vm.putc(0X02);
            vm.putc(0X00);
            vm.putc(0X01);
            vm.putc(0XB4);          
            y = 1;
        }
        
        
        while(RS232_1.readable()) {
             datox = RS232_1.getc();
             wait_us(5000);
             datoUSB[x] = datox;
             x++;
        }
        
        while(BT.readable()) {
             datox = BT.getc();
             wait_us(5000);
             datoUSB[x] = datox;
             x++;
        }
        
        while(RS232_2.readable()) {
             datox = RS232_2.getc();
             wait_us(5000);
             datoUSB[x] = datox;
             x++;
        }
        
         while(TTL.readable()) {
             datox = TTL.getc();
             wait_us(5000);
             datoUSB[x] = datox;
             x++;
        }       
        
         while(RS485.readable()) {
             datox = RS485.getc();
             wait_us(5000);
             datoUSB[x] = datox;
             x++;
        }        
             
        
         if (x != 0) {
            datoUSB[x] = '\0';

            BT.printf("BT: DATA: %s\r\n", datoUSB);
            BT.printf("BT: \nCaracteres: %d\r\n", x);
            BT.printf("BT: \r\n");
            BT.printf("BT: \r\n");
        
            RS232_1.printf("RS232_1: DATA: %s\r\n", datoUSB);
            RS232_1.printf("RS232_1: \nCaracteres: %d\r\n", x);
            RS232_1.printf("RS232_1: \r\n");
            RS232_1.printf("RS232_1: \r\n");
            
            RS232_2.printf("RS232_2: DATA: %s\r\n", datoUSB);
            RS232_2.printf("RS232_2: \nCaracteres: %d\r\n", x);
            RS232_2.printf("RS232_2: \r\n");
            RS232_2.printf("RS232_2: \r\n");

            RS485.printf("RS485: DATA: %s\r\n", datoUSB);
            RS485.printf("RS485: \nCaracteres: %d\r\n", x);
            RS485.printf("RS485: \r\n");
            RS485.printf("RS485: \r\n");
            
            TTL.printf("TTL: DATA: %s\r\n", datoUSB);
            TTL.printf("TTL: \nCaracteres: %d\r\n", x);
            TTL.printf("TTL: \r\n");
            TTL.printf("TTL: \r\n");
                  
            if(strcmp(ONOUTS,datoUSB) == 0) {
                OUT1 = OUT2 = OUT3 = OUT4 = 1;
                i= 1;
                BT.printf("BT: Salidas activadas\r\n");
                RS232_1.printf("RS232_1: Salidas activadas\r\n");
                RS232_2.printf("RS232_2: Salidas activadas\r\n");
                TTL.printf("TTL: Salidas activadas\r\n");
                RS485.printf("RS485: Salidas activadas\r\n");
                vm.putc(0XAA);
                vm.putc(0X07);
                vm.putc(0X02);
                vm.putc(0X00);
                vm.putc(0X0A);
                vm.putc(0XBD);
            }

            else if(strcmp(OFFOUTS,datoUSB) == 0) {
                OUT1 = OUT2 = OUT3 = OUT4 = 0;
                i= 1;
                BT.printf("BT: Salidas desactivadas\r\n");
                RS232_1.printf("RS232_1: Salidas desactivadas\r\n");
                RS232_2.printf("RS232_2: Salidas desactivadas\r\n");
                RS485.printf("RS485: Salidas desactivadas\r\n");
                TTL.printf("TTL: Salidas desactivadas\r\n");
                vm.putc(0XAA);
                vm.putc(0X07);
                vm.putc(0X02);
                vm.putc(0X00);
                vm.putc(0X0B);
                vm.putc(0XBE);              
            }

            else if(strcmp(ONOUT1,datoUSB) == 0) {
                OUT2 = OUT3 = OUT4 = 0;
                OUT1 = 1;
                i= 1;
                BT.printf("BT: Salida 1 Activada\r\n");
                RS232_1.printf("RS232_1: Salida 1 Activada\r\n");
                RS232_2.printf("RS232_2: Salida 1 Activada\r\n");
                RS485.printf("RS485_1: Salida 1 Activada\r\n");
                TTL.printf("TTL: Salida 1 Activada\r\n");
                vm.putc(0XAA);
                vm.putc(0X07);
                vm.putc(0X02);
                vm.putc(0X00);
                vm.putc(0X02);
                vm.putc(0XB5);
            }

            else if(strcmp(ONOUT2,datoUSB) == 0) {
                OUT1 = OUT3 = OUT4 = 0;
                OUT2 = 1;
                i= 1;
                BT.printf("BT: Salida 2 Activada\r\n");
                RS232_1.printf("RS232_1: Salida 2 Activada\r\n");
                RS232_2.printf("RS232_2: Salida 2 Activada\r\n");
                RS485.printf("RS485: Salida 2 Activada\r\n");
                TTL.printf("TTL: Salida 2 Activada\r\n");
                vm.putc(0XAA);
                vm.putc(0X07);
                vm.putc(0X02);
                vm.putc(0X00);
                vm.putc(0X03);
                vm.putc(0XB6);
            }

            else if(strcmp(ONOUT3,datoUSB) == 0) {
                OUT1 = OUT2 = OUT4  = 0;
                OUT3 = 1;
                i= 1;
                BT.printf("BT: Salida 3 Activada\r\n");
                RS232_1.printf("RS232_1: Salida 3 Activada\r\n");
                RS232_2.printf("RS232_2: Salida 3 Activada\r\n");
                RS485.printf("RS485: Salida 3 Activada\r\n");
                TTL.printf("TTL: Salida 3 Activada\r\n");
                vm.putc(0XAA);
                vm.putc(0X07);
                vm.putc(0X02);
                vm.putc(0X00);
                vm.putc(0X04);
                vm.putc(0XB7);
            }

            else if(strcmp(ONOUT4,datoUSB) == 0) {
                OUT1 = OUT2 = OUT3 = 0;
                OUT4 = 1;
                i= 1;
                BT.printf("BT: Salida 4 Activada\r\n");
                RS232_1.printf("RS232_1: Salida 4 Activada\r\n");
                RS232_2.printf("RS232_2: Salida 4 Activada\r\n");
                RS485.printf("RS485: Salida 4 Activada\r\n");
                TTL.printf("TTL: Salida 4 Activada\r\n");
                vm.putc(0XAA);
                vm.putc(0X07);
                vm.putc(0X02);
                vm.putc(0X00);
                vm.putc(0X05);
                vm.putc(0XB8);
            }
            
            else if(strcmp(ON3V3,datoUSB) == 0) {
                re_3v3 = 1;
                BT.printf("BT: Regulador 3.3V activado\r\n");
                RS232_1.printf("RS232_1: Regulador 3.3V activado\r\n");
                RS232_2.printf("RS232_2: Regulador 3.3V activado\r\n");
                RS485.printf("RS485: Regulador 3.3V activado\r\n");
                TTL.printf("TTL: Regulador 3.3V activado\r\n");
                vm.putc(0XAA);
                vm.putc(0X07);
                vm.putc(0X02);
                vm.putc(0X00);
                vm.putc(0X06);
                vm.putc(0XB9);
            }
            
                else if(strcmp(OFF3V3,datoUSB) == 0) {
                re_3v3 = 0;
                BT.printf("BT: Regulador 3.3V desactivado\r\n");
                RS232_1.printf("RS232_1: Regulador 3.3V desactivado\r\n");
                RS232_2.printf("RS232_2:Regulador 3.3V desactivado\r\n");
                RS485.printf("RS485: Regulador 3.3V desactivado\r\n");
                TTL.printf("TTL: Regulador 3.3V desactivado\r\n");
                vm.putc(0XAA);
                vm.putc(0X07);
                vm.putc(0X02);
                vm.putc(0X00);
                vm.putc(0X07);
                vm.putc(0XBA);
            }
            
                else if(strcmp(RSTBT,datoUSB) == 0) {
                BT_RST = 0;
                wait_us(100000);
                BT_RST = 1;
                y = 0;
                
                BT.printf("BT: Reset BT\r\n");
                RS232_1.printf("RS232_1: Reset BT\r\n");
                RS232_2.printf("RS232_2: Reset BT\r\n");
                RS485.printf("RS485: Reset BT\r\n");
                TTL.printf("TTL: Reset BT\r\n");
            }
                        
                else if(strcmp(ON5V,datoUSB) == 0) {
                re_5v = 1;
                BT.printf("BT: Regulador 5V activado\r\n");
                RS232_1.printf("RS232_1: Regulador 5V activado\r\n");
                RS232_2.printf("RS232_2: Regulador 5V activado\r\n");
                RS485.printf("RS485: Regulador 5V activado\r\n");
                TTL.printf("TTL: Regulador 5V activado\r\n");
                vm.putc(0XAA);
                vm.putc(0X07);
                vm.putc(0X02);
                vm.putc(0X00);
                vm.putc(0X08);
                vm.putc(0XBB);
            }
            
                else if(strcmp(OFF5V,datoUSB) == 0) {
                re_5v = 0; 
                BT.printf("BT: Regulador 5V desactivado\r\n");
                RS232_1.printf("RS232_1: Regulador 5V desactivado\r\n");
                RS232_2.printf("RS232_2: Regulador 5V desactivado\r\n");
                RS485.printf("RS485: Regulador 5V desactivado\r\n");
                TTL.printf("TTL: Regulador 5V desactivado\r\n");
                vm.putc(0XAA);
                vm.putc(0X07);
                vm.putc(0X02);
                vm.putc(0X00);
                vm.putc(0X09);
                vm.putc(0XBC);
            }
            
                else if(strcmp(ANTO,datoUSB) == 0) {
                vm.putc(0XAA);
                vm.putc(0X07);
                vm.putc(0X02);
                vm.putc(0X00);
                vm.putc(0X0C);
                vm.putc(0XBF);
            }
    
            else{
                BT.printf("BT: COMANDO INVALIDO\n");
                RS232_1.printf("RS232_1: COMANDO INVALIDO\n");
                RS232_2.printf("RS232_2: COMANDO INVALIDO\n");
                RS485.printf("RS485: COMANDO INVALIDO\n");
                TTL.printf("TTL: COMANDO INVALIDO\n");
                }
      }
      
        wait_us(3000000);
    }//while true
}//main
