/*
 * - Proyecto:      Detektor Fuel Truck Monitoring System
                    Interconexión de Múltiples UFS270.
 * - Lenguaje:      ANSI C/C++ (mbed)
 * - Tarjeta:       Nucleo F091RC
 * - Referencias:
 * - Fecha:         2016/Mar
 * - Autor(es):     Felícito Manzano /
                    Mario Vargas
 * - Compañia:      V.S.R. de Centroamérica
 * - País:          SV / CR
*/

#include "DebounceIn.h"
#include "BufferedSerial.h"

/* DEFINICIÓN DE FUNCIONES */
/*******************************************************************/
/*******************************************************************/
/*******************************************************************/
int ufs270_tfms(BufferedSerial *puerto_data, char nivel[6], char hw[2], char sw[2])
{
    /* Descripción de la función.

    REAL TIME FUEL LEVEL!!

    Esta función recibe un puerto serial Buffered en el que se recibe la trama
    *QL,411D,01,01580,02D0,2205,01551,null#

    +-------------------------------------------------------+
    | PARAMETER            | LENGHT | EXAMPLE | DESCRIPTION |
    +----------------------+--------+---------+-------------+
    | HEADER               |    3   |   *QL,  |             |
    | PROTOCOL             |    1   |     4   |             |
    | FIRMWARE             |    2   |    11   |             |
    | HARDWARE             |    1   |     D,  |             |
    | RESERVED             |    2   |    01,  |             |
    | CALCULATE FUEL LEVEL |    5   | 01580,  | Unit 0.1 mm |
    | SIGNAL STRENG        |    2   |    02   |             |
    | SOFTWARE STATUS CODE |    1   |     D   |             |
    | HARDWARE FAULT CODE  |    1   |     0,  |             |
    | RESERVED             |    4   |  2205,  |             |
    | REAL TIME FUEL LEVEL |    5   | 01551,  | Unit 0.1 mm |
    | RESERVED             |    4   |  null   |             |
    | TAIL                 |    1   |     #   |             |
    +----------------------+--------+---------+-------------+

    Se lee caracter por caracter, al encontrar un asterisco se inicia el conteo
    de caracteres, aprovechando que la longitud de la trama es fija se extrae la
    información de nivel de combustible (REAL TIME FUEL LEVEL) en base al contador
    de caracteres, también se extrae el estatus de software y hardware.

    Si existe información en puerto Serial y es legible se retorna 1.
    Si no existe información para leer en el puerto Serial se retorna 0.
    */

    char ufs270_begin = '*';
    int char_fuel = 29;
    int char_fuel_limit = 33;
    int char_swstatus = 21;
    int char_hwstatus = 22;
    int char_counter = 0;
    int z = 0;
    int begin = 0;

    while (puerto_data -> readable()) {
        // If the character on the
        char incoming_char = puerto_data -> getc();
        if (incoming_char == ufs270_begin) {
            char_counter = 1;
            z=0;
            begin = 1;
        } else {
            char_counter++;
        }
        if ((char_counter == char_swstatus) && begin) {
            sw[0] = incoming_char;
        } else if ((char_counter == char_hwstatus) && begin) {
            hw[0] = incoming_char;
        } else if ((char_counter >= char_fuel) && (char_counter <= char_fuel_limit) && begin) {
            nivel[z] = incoming_char;
            z++;
        }
    }

    if (begin) {
        return (1);
    } else {
        return (0);
    }
}

/*******************************************************************/
/*******************************************************************/
/*******************************************************************/

int ufs270_calculateFL(BufferedSerial *puerto_data, char nivel[6], char hw[2], char sw[2])
{
    /* Descripción de la función.

    CALCULATE FUEL LEVEL

    Esta función recibe un puerto serial Buffered en el que se recibe la trama
    *QL,411D,01,01580,02D0,2205,01551,null#

    +-------------------------------------------------------+
    | PARAMETER            | LENGHT | EXAMPLE | DESCRIPTION |
    +----------------------+--------+---------+-------------+
    | HEADER               |    3   |   *QL,  |             |
    | PROTOCOL             |    1   |     4   |             |
    | FIRMWARE             |    2   |    11   |             |
    | HARDWARE             |    1   |     D,  |             |
    | RESERVED             |    2   |    01,  |             |
    | CALCULATE FUEL LEVEL |    5   | 01580,  | Unit 0.1 mm |
    | SIGNAL STRENG        |    2   |    02   |             |
    | SOFTWARE STATUS CODE |    1   |     D   |             |
    | HARDWARE FAULT CODE  |    1   |     0,  |             |
    | RESERVED             |    4   |  2205,  |             |
    | REAL TIME FUEL LEVEL |    5   | 01551,  | Unit 0.1 mm |
    | RESERVED             |    4   |  null   |             |
    | TAIL                 |    1   |     #   |             |
    +----------------------+--------+---------+-------------+

    Se lee caracter por caracter, al encontrar un asterisco se inicia el conteo
    de caracteres, aprovechando que la longitud de la trama es fija se extrae la
    información de nivel de combustible en base al contador de caracteres, también
    se extrae el estatus de software y hardware.

    Si existe información en puerto Serial y es legible se retorna 1.
    Si no existe información para leer en el puerto Serial se retorna 0.
    */
    char ufs270_begin = '*';
    int char_fuel = 13;
    int char_fuel_limit = 17;
    int char_swstatus = 21;
    int char_hwstatus = 22;
    int char_counter = 0;
    int z = 0;
    int begin = 0;

    if (puerto_data -> readable()) {
        while (puerto_data -> readable()) {
            // If the character on the
            char incoming_char = puerto_data -> getc();
            if (incoming_char == ufs270_begin) {
                char_counter = 1;
                z=0;
                begin = 1;
            } else {
                char_counter++;
            }
            if ((char_counter >= char_fuel) && (char_counter <= char_fuel_limit) && begin) {
                nivel[z] = incoming_char;
                z++;
            } else if ((char_counter == char_swstatus) && begin) {
                sw[0] = incoming_char;
            } else if ((char_counter == char_hwstatus) && begin) {
                hw[0] = incoming_char;
            }
        }
        return (1);
    } else {
        return (0);
    }
}

/*******************************************************************/
/*******************************************************************/
/*******************************************************************/

int configurar_entradas(DebounceIn *i_0, DebounceIn *i_1, DebounceIn *i_2,
                        DebounceIn *i_3, DebounceIn *i_4, DebounceIn *i_5,
                        DebounceIn *i_6)
{
    /* Descripción de la función.
    Utilizando la librería DebounceIn para filtrar entradas digitales
    se configuran las 9 entradas digitales en modo PullUp, se define
    el tiempo de muestreo a 40ms (40000us) y la cantidad de muestras
    para validar en 20.
    Esta función siempre retorna 1
    */

    // Tiempo para filtrar:
    // 50 milisegundos
    int rebote_us = 50000;

    // Cantidad de muestras para filtrar
    int muestras = 10;

    // Configurar en modo PullUp
    i_0 -> mode(PullUp);
    i_1 -> mode(PullUp);
    i_2 -> mode(PullUp);
    i_3 -> mode(PullUp);
    i_4 -> mode(PullUp);
    i_5 -> mode(PullUp);
    i_6 -> mode(PullUp);

    // Tiempo de Espera para que se tome el cambio
    // en la configuración de entradas a PullUp
    wait_ms(10);

    // Modificar el tiempo de rebote
    i_0 -> set_debounce_us(rebote_us);
    i_1 -> set_debounce_us(rebote_us);
    i_2 -> set_debounce_us(rebote_us);
    i_3 -> set_debounce_us(rebote_us);
    i_4 -> set_debounce_us(rebote_us);
    i_5 -> set_debounce_us(rebote_us);
    i_6 -> set_debounce_us(rebote_us);

    // Modificar la cantidad de muestras
    i_0 -> set_samples(muestras);
    i_1 -> set_samples(muestras);
    i_2 -> set_samples(muestras);
    i_3 -> set_samples(muestras);
    i_4 -> set_samples(muestras);
    i_5 -> set_samples(muestras);
    i_6 -> set_samples(muestras);

    return(1);
}

/*******************************************************************/
/*******************************************************************/
/*******************************************************************/

int leer_entradas(DebounceIn *i_0, DebounceIn *i_1, DebounceIn *i_2,
                  DebounceIn *i_3, DebounceIn *i_4, DebounceIn *i_5,
                  DebounceIn *i_6, int entradas[7])
{
    /* Descripción de Función:
    Esta función realiza la lectura de las 19 entradas digitales.
    El resultado de las lecturas se almacena en un vector entero
    de 19 posiciones. Siempre se retorna un valor 1.
    */

    // Entradas Digitales
    entradas[0] = i_0 -> read();
    wait_ms(5);

    entradas[1] = i_1 -> read();
    wait_ms(5);

    entradas[2] = i_2 -> read();
    wait_ms(5);

    entradas[3] = i_3 -> read();
    wait_ms(5);

    entradas[4] = i_4 -> read();
    wait_ms(5);

    entradas[5] = i_5 -> read();
    wait_ms(5);

    entradas[6] = i_6 -> read();
    wait_ms(5);

    return (1);
}

/*******************************************************************/
/*******************************************************************/
/*******************************************************************/

int comparar_entradas(int previas[7], int actuales[7])
{
    /* Descripción de función:
    Esta función recibe dos vectores de enteros con 19 posiciones.
    Cada posición representa una de las entradas del mando eléctrico.
    Se realiza la comparación de cada posición, si una de las
    posiciones es diferente se devuelve el valor 1 para indicar
    que son diferentes. Si todas las posiciones son iguales entonces
    se devuelve 0 para indicar que son iguales.
    */

    // Variables locales
    int son_iguales = 0;
    int entradas = 7;
    int z;

    for (z=0; z<entradas; z++) {
        (previas[z] == actuales[z]) ? (son_iguales  *= 1) : son_iguales++;
    }

    if (son_iguales > 0) {
        return (1);
    } else {
        return (0);
    }
}

/*******************************************************************/
/*******************************************************************/
/*******************************************************************/

int incrementar_trama(int *tramas)
{
    /*
    Esta función recibe un entero que es el contador de tramas
    realiza el incremento en uno y verifica si el valor es mayor
    o igual que 65535 que es equivalente a 0xFFFF. Si se cumple
    la condución se regresa el valor a 1.
    Esta función siempre retorna 0.
    */
    int actual = *tramas;
    int limite = 65535;
    actual++;

    if (actual > limite) {
        *tramas = 1;
    } else {
        *tramas = actual;
    }
    return(0);
}