/*
 * - Proyecto:      Accesorios  Queclink.
 * - Lenguaje:      ANSI C/C++ (mbed)
 * - Tarjeta:       Nucleo F091RC
 * - Referencias:
 * - Fecha:         2016/May
 * - Autor(es):     Felícito Manzano /
                    Mario Vargas
 * - Compañia:      V.S.R. de Centroamérica
 * - País:          SV / CR
*/

#include "constantes.hpp"

int incrementar_trama(int *tramas)
{
    /*
    Esta función recibe un entero que es el contador de tramas
    realiza el incremento en uno y verifica si el valor es mayor
    o igual que 65535 que es equivalente a 0xFFFF. Si se cumple
    la condución se regresa el valor a 1.
    Esta función siempre retorna 0.
    */
    int actual = *tramas;
    int limite = 65535;
    actual++;

    if (actual > limite) {
        *tramas = 1;
    } else {
        *tramas = actual;
    }
    return(0);
}

int booting_gtdat(Serial *puerto_gv300, Serial *puerto_usb)
{
    /*
    Esta función recibe los puertos Seriales del GV300 y de la PC
    conectada por USB para notificar que se ha reiniciado la interfaz.
    Siempre retorna 0
    */
    puerto_usb -> printf("*** BOOTING ***\r\n");
    puerto_usb -> printf("VSR de Centroamerica\r\nSerial Port - OK\r\n");
    puerto_usb -> printf("Enviar mensaje de re-inicio a CP\r\n\n");
    wait_ms(T_TX);
    puerto_gv300 -> printf("%s\r\n", RESET_TXT);
    wait_ms(T_ESPERA_CP);
    puerto_usb -> printf("%s\r\n", RESET_TXT);
    wait_ms(T_TX);

    return(0);
}

