/*
 * - Proyecto:      CH SABMiller.
 * - Lenguaje:      ANSI C/C++ (mbed)
 * - Tarjeta:       Nucleo F091RC
 * - Referencias:
 * - Fecha:         2016/May
 * - Autor(es):     Felícito Manzano /
                    Mario Vargas
 * - Compañia:      V.S.R. de Centroamérica
 * - País:          SV / CR
*/

#include "mbed.h"
#include "BufferedSerial.h"
#include "constantes.hpp"

/* DEFINICIÓN DE FUNCIONES */
/*******************************************************************/
/*******************************************************************/

int ufs270_rtFL(BufferedSerial *puerto_data, char nivel[6], char hw[2], char sw[2])
{
    /*
    Descripción de la función.

    REAL TIME FUEL LEVEL!!

    Esta función recibe un puerto serial Buffered en el que se recibe la trama
    *QL,411D,01,01580,02D0,2205,01551,null#

    +-------------------------------------------------------+
    | PARAMETER            | LENGHT | EXAMPLE | DESCRIPTION |
    +----------------------+--------+---------+-------------+
    | HEADER               |    3   |   *QL,  |             |
    | PROTOCOL             |    1   |     4   |             |
    | FIRMWARE             |    2   |    11   |             |
    | HARDWARE             |    1   |     D,  |             |
    | RESERVED             |    2   |    01,  |             |
    | CALCULATE FUEL LEVEL |    5   | 01580,  | Unit 0.1 mm |
    | SIGNAL STRENG        |    2   |    02   |             |
    | SOFTWARE STATUS CODE |    1   |     D   |             |
    | HARDWARE FAULT CODE  |    1   |     0,  |             |
    | RESERVED             |    4   |  2205,  |             |
    | REAL TIME FUEL LEVEL |    5   | 01551,  | Unit 0.1 mm |
    | RESERVED             |    4   |  null   |             |
    | TAIL                 |    1   |     #   |             |
    +----------------------+--------+---------+-------------+

    Se lee caracter por caracter, al encontrar un asterisco se inicia el conteo
    de caracteres, aprovechando que la longitud de la trama es fija se extrae la
    información de nivel de combustible (REAL TIME FUEL LEVEL) en base al contador
    de caracteres, también se extrae el estatus de software y hardware.

    Si existe información en puerto Serial y es legible se retorna 1.
    Si no existe información para leer en el puerto Serial se retorna 0.
    */

    char ufs270_begin = '*';
    int char_fuel = 29;
    int char_fuel_limit = 33;
    int char_swstatus = 21;
    int char_hwstatus = 22;
    
    int char_counter = 0;
    int z = 0;
    int begin = 0;

    while (puerto_data -> readable()) {
        // If the character on the
        char incoming_char = puerto_data -> getc();
        if (incoming_char == ufs270_begin) {
            char_counter = 1;
            z=0;
            begin = 1;
        } else {
            char_counter++;
        }
        if ((char_counter == char_swstatus) && begin) {
            sw[0] = incoming_char;
        } else if ((char_counter == char_hwstatus) && begin) {
            hw[0] = incoming_char;
        } else if ((char_counter >= char_fuel) && (char_counter <= char_fuel_limit) && begin) {
            nivel[z] = incoming_char;
            z++;
        }
    }

    if (begin) {
        return (1);
    } else {
        return (0);
    }
}



int ufs270_calcFL(BufferedSerial *puerto_data, char nivel[6], char hw[2], char sw[2])
{
    /* Descripción de la función.

    CALCULATE FUEL LEVEL

    Esta función recibe un puerto serial Buffered en el que se recibe la trama
    *QL,411D,01,01580,02D0,2205,01551,null#

    +-------------------------------------------------------+
    | PARAMETER            | LENGHT | EXAMPLE | DESCRIPTION |
    +----------------------+--------+---------+-------------+
    | HEADER               |    3   |   *QL,  |             |
    | PROTOCOL             |    1   |     4   |             |
    | FIRMWARE             |    2   |    11   |             |
    | HARDWARE             |    1   |     D,  |             |
    | RESERVED             |    2   |    01,  |             |
    | CALCULATE FUEL LEVEL |    5   | 01580,  | Unit 0.1 mm |
    | SIGNAL STRENG        |    2   |    02   |             |
    | SOFTWARE STATUS CODE |    1   |     D   |             |
    | HARDWARE FAULT CODE  |    1   |     0,  |             |
    | RESERVED             |    4   |  2205,  |             |
    | REAL TIME FUEL LEVEL |    5   | 01551,  | Unit 0.1 mm |
    | RESERVED             |    4   |  null   |             |
    | TAIL                 |    1   |     #   |             |
    +----------------------+--------+---------+-------------+

    Se lee caracter por caracter, al encontrar un asterisco se inicia el conteo
    de caracteres, aprovechando que la longitud de la trama es fija se extrae la
    información de nivel de combustible en base al contador de caracteres, también
    se extrae el estatus de software y hardware.

    Si existe información en puerto Serial y es legible se retorna 1.
    Si no existe información para leer en el puerto Serial se retorna 0.
    */
    char ufs270_begin = '*';
    int char_fuel = 13;
    int char_fuel_limit = 17;
    int char_swstatus = 21;
    int char_hwstatus = 22;
    
    int char_counter = 0;
    int z = 0;
    int begin = 0;

    if (puerto_data -> readable()) {
        while (puerto_data -> readable()) {
            // If the character on the
            char incoming_char = puerto_data -> getc();
            if (incoming_char == ufs270_begin) {
                char_counter = 1;
                z=0;
                begin = 1;
            } else {
                char_counter++;
            }
            if ((char_counter >= char_fuel) && (char_counter <= char_fuel_limit) && begin) {
                nivel[z] = incoming_char;
                z++;
            } else if ((char_counter == char_swstatus) && begin) {
                sw[0] = incoming_char;
            } else if ((char_counter == char_hwstatus) && begin) {
                hw[0] = incoming_char;
            }
        }
        return (1);
    } else {
        return (0);
    }
}
