/*
 * - Proyecto:      Accesorios  Queclink.
 * - Lenguaje:      ANSI C/C++ (mbed)
 * - Tarjeta:       Nucleo F091RC
 * - Referencias:
 * - Fecha:         2016/May
 * - Autor(es):     Felícito Manzano /
                    Mario Vargas
 * - Compañia:      V.S.R. de Centroamérica
 * - País:          SV / CR
*/

#include "mbed.h"
#include "BufferedSerial.h"
#include "funciones_basicas.h"
#include "funciones_UFS270.h"
#include "constantes.hpp"
#include <stdio.h>

//HARDWARE SETUP
//***********************************
extern Serial pcusb(USBTX, USBRX);    //Serial ports TX,RX Hardware
extern Serial gv300(PC_10, PC_11);    // Para conexión con el GPS GV300 N/W
extern BufferedSerial fuelR1(PB_10, PB_11); // 1er. tanque de combustible
extern DigitalOut myled(LED1);              // LED1 Integrado
int contador_tramas = 1;


int main()
{
    // CONFIGURAR INTERFACES SERIALES
    pcusb.baud(9600);       // Common PC Baudrate
    gv300.baud(115200);       // GV300 USB Default Baudrate
    fuelR1.baud(19200);     // UFS270 Default Baudrate

    // Mensaje de Inicio
    booting_gtdat(&gv300, &pcusb);

    // Declaración de Variables
    // Nivel de combustible UFS270
    char level_FuelR1[6] = "-----";
    char sw_StatusR1[2] = "-";
    char hw_StatusR1[2] = "-";
    int eval_Fuel1 = 0;
    int contador_TX = 0;


    while(1) {
        myled = 1;
        // Leer UFS270 en el tanque A
        pcusb.printf("UFS270 A - INICIA\r\n");
        eval_Fuel1 = ufs270_rtFL(&fuelR1, level_FuelR1, hw_StatusR1, sw_StatusR1);
        if (eval_Fuel1) {
            pcusb.printf("UFS270_A Altura=%s - OK\r\n",level_FuelR1);   
            contador_TX++;       
        } else {
            pcusb.printf("UFS270_A - SIN DATOS\r\n");
        }
        wait_ms(T_TX); 

              
        // Transmitir
        if ((eval_Fuel1)&&(contador_TX == 3)){
            // Generar transmisión
            pcusb.printf("REPORTE CONSOLIDADO COMBUSTIBLE\r\n");
            pcusb.printf("Inicia comunicacion con CP. Enviando mensaje:\r\n");
            pcusb.printf("%s%sFTMS%s%s%s%c%c%s%04X%s\r\n\n",
                         CABECERA_TX, CODIGO_INT_FUEL, SEPARADOR,
                         level_FuelR1, SEPARADOR, hw_StatusR1[0], sw_StatusR1[0],
                         FIN_CABECERA_TX, contador_tramas, ULTIMO_CARACTER);
            wait_ms(T_ESPERA_CP);
                                
            gv300.printf("%s%sFTMS%s%s%s%c%c%s%04X%s\r\n",
                         CABECERA_TX, CODIGO_INT_FUEL, SEPARADOR,
                         level_FuelR1, SEPARADOR, hw_StatusR1[0], sw_StatusR1[0],
                         FIN_CABECERA_TX, contador_tramas, ULTIMO_CARACTER);
            wait_ms(T_ESPERA_CP);
            contador_TX = 0;
            incrementar_trama(&contador_tramas);
            pcusb.printf("Mensaje escrito en puerto serial del CP\r\n\n");
            wait_ms(T_TX);                  
                   
        }
        /* CIERRE */
        
        pcusb.printf("Contador tx = %d\n", contador_TX);
        pcusb.printf("***FIN***\r\n\n");
        strcpy(level_FuelR1,"-----\0");
        strcpy(sw_StatusR1, "-\0");
        strcpy(hw_StatusR1, "-\0");
        eval_Fuel1 = 0;
        myled = 0;
        wait(2);
    }
}
