#include "mbed.h"

I2C i2c(PB_9, PB_8);
Serial pc(PA_2, PA_3);
int address = 0xA0;
int pointerAdddress = 0;
char s[32] = "5555566666";
char g[32] = "hola Wario";
DigitalOut led1(PB_4);

// function declaration
void writeEEPROM(int address, unsigned int eeaddress, char *data, int size);
void readEEPROM(int address, unsigned int eeaddress, char *data, int size);

// this function has 63 bytes write limit
void writeEEPROM(int address, unsigned int eeaddress, char *data, int size)
{
    char i2cBuffer[size + 2];
    i2cBuffer[0] = (unsigned char)(eeaddress >> 8); // MSB
    i2cBuffer[1] = (unsigned char)(eeaddress & 0xFF); // LSB

    for (int i = 0; i < size; i++) {
        i2cBuffer[i + 2] = data[i];
    }

    int result = i2c.write(address, i2cBuffer, size + 2, false);
    wait_ms(6);
}

// this function has no read limit
void readEEPROM(int address, unsigned int eeaddress, char *data, int size)
{
    char i2cBuffer[2];
    i2cBuffer[0] = (unsigned char)(eeaddress >> 8); // MSB
    i2cBuffer[1] = (unsigned char)(eeaddress & 0xFF); // LSB

    // Reset eeprom pointer address
    int result = i2c.write(address, i2cBuffer, 2, false);
    wait_ms(6);

    // Read eeprom
    i2c.read(address, data, size);
    wait_ms(6);
}

int main()
{
    char data_read[32];
    readEEPROM(address, pointerAdddress, data_read, 32);
    pc.printf("Previous data stored Address 0: %s\n", data_read);
   
    address = 0xA0;
    pointerAdddress = 0;    
    char writeDataLen = 10;
    
    writeEEPROM(0XA0, pointerAdddress, g, writeDataLen);
    pc.printf("Data written: %s\n", g); 
     
    led1 = 0;
    
    while(1){
    led1 = !led1;
    wait_us(1000000);
    
    }

}








