#include "mbed.h"
#include "nRF24L01P.h"

Serial pc(USBTX, USBRX); // tx, rx

nRF24L01P my_nrf24l01p(p5, p6, p7, p8, p9, p10);    // mosi, miso, sck, csn, ce, irq

DigitalOut myled1(LED1);
DigitalOut myled2(LED2);
AnalogIn LM35(p20);
AnalogIn LDR(p19);

#define TRANSFER_SIZE   5

char txData[TRANSFER_SIZE], rxData[TRANSFER_SIZE];

int txDataCnt = 5;
int rxDataCnt = 0;

float Light = 0;
float TemperatureC = 0;
char a[5]; 

float i = 0;
float j = 0;


int main() {

// The nRF24L01+ supports transfers from 1 to 32 bytes, but Sparkfun's
// "Nordic Serial Interface Board" (http://www.sparkfun.com/products/9019)
// Only handles 4 byte transfers in the ATMega code.
    my_nrf24l01p.powerUp();
    my_nrf24l01p.setTxAddress(0xE7E7E7E7E7,5);
    my_nrf24l01p.setRfFrequency(2450);
    my_nrf24l01p.setRfOutputPower(0);    
    

    //my_nrf24l01p.enableAutoRetransmit(1000, 5);     //enableAutoRetransmit ( int delay, int   count);   
    //                                                                                          delay   the delay between restransmits, in uS (250uS..4000uS)
    //                                                                                          count   number of retransmits before generating an error (1..15)
    /*
    //Enable autoAcknowledge
    my_nrf24l01p.enableAutoAcknowledge(0);
    my_nrf24l01p.enableAutoAcknowledge(1);    
    my_nrf24l01p.enableAutoAcknowledge(2);    
    my_nrf24l01p.enableAutoAcknowledge(3);
    my_nrf24l01p.enableAutoAcknowledge(4);    
    my_nrf24l01p.enableAutoAcknowledge(5); 
    */
    
    // Display the (default) setup of the nRF24L01+ chip
    pc.printf( "nRF24L01+ Frequency    : %d MHz\r\n",  my_nrf24l01p.getRfFrequency()   );
    pc.printf( "nRF24L01+ Output power : %d dBm\r\n",  my_nrf24l01p.getRfOutputPower() );
    pc.printf( "nRF24L01+ Data Rate    : %d kbps\r\n", my_nrf24l01p.getAirDataRate()   );
    pc.printf( "nRF24L01+ TX Address   : 0x%010llX\r\n", my_nrf24l01p.getTxAddress()   );
    pc.printf( "nRF24L01+ RX Address   : 0x%010llX\r\n", my_nrf24l01p.getRxAddress(0)  );

    pc.printf( "Type keys to test transfers:\r\n  (transfers are grouped into %d characters)\r\n", TRANSFER_SIZE );

    my_nrf24l01p.setTransferSize( TRANSFER_SIZE );

    //Put device in transmitmode
    my_nrf24l01p.setReceiveMode();             
    my_nrf24l01p.enable();


    while (1) {
        i = 0;
        j = 0;
        
        for (int t = 0; t < 100; t++)
        {
            i = i + LM35.read();     
        }
        
        pc.printf("Temperatuur in %4.1f graden C \n\r", i * 3.3);         
        wait(1);    
  
        // If we've received anything over the host serial link.

        // ...add it to the transmit buffer
        sprintf(a, "%f", i * 3.3); 
        pc.printf("a %f \n\r", a);       
        pc.printf("a1 %c \n\r", a[0]);
        pc.printf("a2 %c \n\r", a[1]);
        pc.printf("a3 %c \n\r", a[2]);
        pc.printf("a4 %c \n\r", a[3]);
        pc.printf("a5 %c \n\r", a[4]);                               
        
        
        
        for(int x = 0; x <=5; x++)
        {
        txData[x] = a[x];
        
        pc.printf("txData[0] %c \n\r", txData[0]);
        pc.printf("txData[1] %c \n\r", txData[1]);
        pc.printf("txData[2] %c \n\r", txData[2]);
        pc.printf("txData[3] %c \n\r", txData[3]);
        pc.printf("txData[4] %c \n\r", txData[4]);           
        
        }
        
        

        //pc.printf("lengte txData: %d \n\r", sizeof(txData));
        //pc.printf("txData count: %d \n\r", txDataCnt);

        // If the transmit buffer is full
        //if ( txDataCnt >= sizeof(txData) ) {
            //pc.printf("eerste if \n\r");
            // Send the transmitbuffer via the nRF24L01+
        my_nrf24l01p.write( NRF24L01P_PIPE_P0, txData, txDataCnt );
        pc.printf("Ik heb verzonden");
        txDataCnt = 5;
        //}

        // Toggle LED1 (to help debug Host -> nRF24L01+ communication)
        myled1 = !myled1;


        /*// If we've received anything in the nRF24L01+...
        if ( my_nrf24l01p.readable(NRF24L01P_PIPE_P0) ) {
            //pc.printf("tweede if \n\r");
            // ...read the data into the receive buffer
            rxDataCnt = my_nrf24l01p.read( NRF24L01P_PIPE_P0, rxData, sizeof( rxData ) );

            // Display the receive buffer contents via the host serial link
            for ( int i = 0; rxDataCnt > 0; rxDataCnt--, i++ ) {

                pc.putc( rxData[i] );
            }

            // Toggle LED2 (to help debug nRF24L01+ -> Host communication)
            myled2 = !myled2;
        }*/
    }
}
                                                     