#ifndef __UCAM__H__
#define __UCAM__H__
#include <mbed.h>
/*color space*/
#define COLOR_YUV_2     0x01
#define COLOR_YUV_4     0x02
#define COLOR_YUV_8     0x03
#define COLOR_RGB_332   0x04
#define COLOR_RGB_444   0x05
#define COLOR_RGB_565   0x06
#define COLOR_JPEG      0x07
/*raw resolution*/
#define RAW_80x60       0x01
#define RAW_160x120     0x03
#define RAW_320x240     0x05
#define RAW_640x480     0x07
#define RAW_128x128     0x09
#define RAW_128x96      0x0B
/*jpeg resolution*/
#define JPEG_80x64      0x01
#define JPEG_160x128    0x03
#define JPEG_320x240    0x05
#define JPEG_640x480    0x07
struct ucam_command;

class UCam{
    public:
        Serial *ucam;
        DigitalOut led;
        
    public:        
        UCam(PinName tx_pin, PinName rx_pin, PinName led_pin, uint32_t baudrate);
        ~UCam();
        int8_t connect();
        int8_t snapshot(uint8_t *buf, uint16_t *len, uint8_t colorspace, uint8_t raw_size, uint8_t jpeg_size);
        int8_t start_video(uint8_t colorspace, uint8_t raw_size, uint8_t jpeg_size);
        int8_t next_frame(uint8_t *buf, uint16_t *len);
        int8_t end_video();
        
    private:
        void uart_isr();
        int8_t send_cmd(uint8_t cmd, uint8_t p1=0, uint8_t p2=0, uint8_t p3=0, uint8_t p4=0, uint8_t noack=0);
        int8_t recv_cmd(struct ucam_command *cmd);
};
#endif/*#define __UCAM_H__*/