#include "mbed.h"
#include "ucam.h"
#define BUFFER_LENGTH 4096

Serial firefly(p28, p27);
Serial debug(USBTX, USBRX);

DigitalOut firefly_led(LED1);
UCam ucam(p13, p14, LED2, 1228800);  // tx, rx, led, baud

uint16_t len;
uint8_t ubuf[BUFFER_LENGTH];
uint8_t take_snapshot  =0;

void firefly_isr()
{
    while(firefly.readable())
        firefly.getc();
    take_snapshot = 1;
}

int main()
{
    debug.puts("initiating firefly...\r\n");
    firefly.baud(921600);     
    firefly.attach(firefly_isr);
    firefly_led = 1;
    
    debug.puts("initiating ucam...\r\n");
        
    if (ucam.connect() == 0){
        debug.puts("connection to ucam established\r\n");
    } else {
        debug.puts("connection to ucam failed\r\n");
        return -1;
    }


    if (ucam.start_video(COLOR_JPEG, JPEG_160x128, JPEG_160x128) != 0) {
            debug.printf("failed to start video\r\n");
            return -1;
    }

    Timer t;
    uint16_t i;    
    
    while (1) {   
    
        t.reset();
        
        if (take_snapshot 
                && ucam.next_frame(ubuf, &len) == 0) {

            firefly.putc(((char*)&len)[0]); //size lsb
            firefly.putc(((char*)&len)[1]); //size msb
 
            for(i=0; i < len; i++){
                firefly.putc(ubuf[i]);
            }
            
            take_snapshot = 0;    
            debug.printf("frame %f \r\n", t.read());
        }
        wait_ms(10);
    }    
}