#ifndef __NRFLASH_H__
#define __NRFLASH_H__
#include <mbed.h>
class NRFlash {
    private:
        SPI spi;
        DigitalOut ssel;
        DigitalOut prog;
        DigitalOut rst;
        void write_enable();
    public:
        NRFlash(PinName mosi, PinName miso, PinName sclk, PinName ssel, PinName prog, PinName rst);
        void reset();
        void enable_programming();
        void disable_programming();
        int  read_fsr();
        void write_fsr(int fsr);
        void erase_flash();
        int read_flash(const char *path);
        int write_flash(const char *path);
};
#endif //__NRFLASH_H__