/**
 * Copyright (c) 2011 Ibrahim Abd Elkader
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 * Program Nordic nRF24LU1+ chips using SPI.
 * Instructions:
 * 1)convert the ihx to binary using objcopy like this:
 *   objcopy --gap-fill 255 -Iihex -O binary nrf.ihx nrf.bin
 * 2)copy nrf.bin to MBED flash
 * 3)copy nrflash to MBED flash
 * 4)reset the MBED
 **/
#include <nrflash.h> 
NRFlash nrflash(p11, p12, p13, p14, p15, p16); //mosi, miso, sck, ssel, prog, reset
LocalFileSystem local("local");

int main() 
{   
    nrflash.enable_programming();
    
    printf("FSR: %d\n", nrflash.read_fsr());
    printf("erasing flash...\n");        
    nrflash.erase_flash();
        
    printf("flashing...\n");
    nrflash.write_flash("/local/nrf.bin");
    
    printf("saving flash...\n");
    nrflash.read_flash("/local/flash.bin"); 
    printf("all done...\n");
    
    nrflash.disable_programming();
    nrflash.reset();
    
    return 0;
}
