#include <nrflash.h>
#define WREN        (0x06)    /*Set flash write enable,FSR.WEN*/             
#define WRDIS       (0x04)    /*Reset flash write enable, FSR.WEN*/             
#define RDSR        (0x05)    /*1 (or more) Read Flash Status Register (FSR)*/             
#define WRSR        (0x01)    /*1 Write Flash Status Register (FSR).*/
#define READ        (0x03)    /*Read data from flash*/                                                   
#define PROGRAM     (0x02)    /*Write data to flash*/             
#define ERASE_PAGE  (0x52)    /*Erase addressed flash page*/
#define ERASE_ALL   (0x62)    /* Erase all pages of flash MainBlock*/
#define RDFPCR      (0x89)    /*Read Flash Protect Configuration Register (FPCR)*/
#define RDISIP      (0x84)    /*Set flash InfoPage read-back disable*/
#define RDISMB      (0x85)    /*Set flash MainBlock read-back disable*/
#define ENDEBUG     (0x86)    /*Write 0x00 to InfoPage byte 0x24*/
#define RDYN        (1<<4)
#define FLASH_LEN   (32768)
NRFlash::NRFlash(PinName mosi, PinName miso, PinName sclk, PinName ssel_, PinName prog_, PinName rst_):
spi(mosi, miso, sclk), 
ssel(ssel_),
prog(prog_),
rst(rst_)
{
    spi.frequency(12500000);
    spi.format(8, 0);
    rst = 1;
}

void NRFlash::reset()
{
    rst = 0;
    wait_ms(2);
    rst = 1;
}

void NRFlash::enable_programming()
{
    prog = 1;
    wait_ms(2);
}

void NRFlash::disable_programming()
{
    prog = 0;   
}

void NRFlash::write_enable()
{
    ssel = 0;
    spi.write(WREN);
    ssel = 1;
}

int NRFlash::read_fsr()
{
    int fsr;
    ssel = 0;
    spi.write(RDSR);
    fsr = spi.write(0);
    ssel = 1;
    return fsr;
}

void NRFlash::write_fsr(int fsr)
{
    ssel = 0;   
    spi.write(WRSR);
    spi.write(fsr);
    ssel = 1;
}

void NRFlash::erase_flash()
{
    write_enable();
    ssel = 0;    
    spi.write(ERASE_ALL);
    ssel = 1;
    while (read_fsr() & RDYN); /*wait for flash to be erased*/    
}

int NRFlash::read_flash(const char *path)
{
    int bytes = 0;
    int count = 0;
    char buf[1024];
    
    FILE *fp = fopen(path, "wb");
    if (fp == NULL) {
        printf("file not found\n");
        return -1;
    }        
    ssel = 0;   
    spi.write(READ);
    spi.write(0);
    spi.write(0);
    while (bytes++ < FLASH_LEN) {
        buf[count++] = spi.write(0);
        if (count == sizeof(buf)) {
            count = 0;
            fwrite(buf, 1, sizeof(buf), fp);
        }
    }
    ssel = 1;
    fclose(fp);
    return 0;
}

int NRFlash::write_flash(const char *path)
{
    int len;
    uint16_t addr = 0;
    char buf[256];
        
    FILE *fp = fopen(path, "rb");
    if (fp == NULL) {
        printf("file not found\n");
        return -1;
    }
       
    while ((len = fread(buf, 1, sizeof(buf), fp)) > 0) {
        write_enable();
        ssel = 0;
        spi.write(PROGRAM);   /*PROGRAM command*/
        spi.write(addr>>8);   /*write address MSB*/
        spi.write(addr&0x0F); /*write address LSB*/    
        addr += len;
        for (int i=0; i<len; i++) {
            spi.write(buf[i]);
        }        
        ssel = 1;               
        while (read_fsr() & RDYN); /*wait for flash to be ready*/
    }
    fclose(fp);
    return 0; 
}