#include "mbed.h"
#define BMA180_ID       0x00
#define BMA180_ADDR     0x80 //datasheet says 0x40 !
#define BMA180_X_ACC    0x02
#define BMA180_Y_ACC    0x04
#define BMA180_Z_ACC    0x06
#define BMA180_SDA      p9
#define BMA180_SCL      p10
I2C i2c(BMA180_SDA, BMA180_SCL);

int main() {
    char data[2];
    int16_t x,y,z;
    
    i2c.frequency(100000);
    
    //read chip_id
    data[0] = BMA180_ID;
    data[1] = 0x00;
    
    i2c.write(BMA180_ADDR, data, 1);    
    i2c.read(BMA180_ADDR, data, 1);  
        
    if (data[0] != 0x03) {
        printf("invalid chip id %d\n", data[0]);
        return 1;
    }
    
    while(1) {
        data[0] = BMA180_X_ACC;
        i2c.write(BMA180_ADDR, data, 1);
        i2c.read(BMA180_ADDR, data, 2);
        data[0] >>= 2;
        x  = *((int16_t*)data);
        
        data[0] = BMA180_Y_ACC;
        i2c.write(BMA180_ADDR, data, 1);
        i2c.read(BMA180_ADDR, data, 2);
        data[0] >>= 2;
        y  = *((int16_t*)data);
       
        data[0] = BMA180_Z_ACC;
        i2c.write(BMA180_ADDR, data, 1);
        i2c.read(BMA180_ADDR, data, 2);
        data[0] >>= 2;
        z  = *((int16_t*)data);
                
        //printf("x: %d y: %d z: %d\n", x, y, z);
        printf("x: %.1f y: %.1f z: %.1f\n", x/16384.0f, y/16384.0f, z/16384.0f); //2^14
        
        wait_ms(100);
    }
}
