#include "mbed.h"
#include "TextLCD.h"
#include "DebounceIn.h"
#include "DS1820.h"

/*
   This basic example just shows how to read the ADC internal channels raw values.
   Please look in the corresponding device reference manual for a complete
   description of how to make a temperature sensor, VBat or Vref measurement.
*/

// Temperature input
//AnalogIn adc_temp1(A0);
AnalogIn adc_temp2(A1);
AnalogIn adc_temp3(A2);

// Switch input
DebounceIn tempUp(A3);
DebounceIn tempDown(A4);
DebounceIn onOff(A5);

// LCD
TextLCD lcd(D0, D1, D2, D3, D4, D5); // rs, e, d4-d7

// LED
DigitalOut led(LED1);

// PWM
PwmOut fan(D12);

// Temp
DS1820 ds1820(A0);

uint8_t tempSetValue = 25; // degree
bool fanOn = false;
float fanDutyCycle = 0.0f;

uint8_t ds1820Counter = 0;
uint8_t temp1 = 0;

//const uint8_t PRESS_DURATION = 5;

int main()
{
    // Configure pull-up
    tempUp.mode(PullUp);
    tempDown.mode(PullUp);
    onOff.mode(PullUp);
    // 100 ms debounce
    tempUp.set_samples(100);
    tempDown.set_samples(100);
    onOff.set_samples(100);
    
    fan.period(4.0f); // period
    fan.write(fanDutyCycle); // duty cycle
    
    if (ds1820.begin()) lcd.printf("DS1820 found!");
    else lcd.printf("DS1820 not found");
    wait(1.0);
    lcd.cls();
    // Loop
    while(1) {
        //uint8_t temp1 = static_cast<uint8_t>(adc_temp1.read()*3.3f*100.0f);
        
        if (ds1820Counter == 0) ds1820.startConversion();
        if(ds1820Counter++ == 50)  {
            float ds1820Temp = 0.0f;
            if(ds1820.read(ds1820Temp) == 0) {
                temp1 = static_cast<uint8_t>(ds1820Temp);
            }
            ds1820Counter = 0;
        }
        
        uint8_t temp2 = static_cast<uint8_t>(adc_temp2.read()*3.3f*100.0f);
        uint8_t temp3 = static_cast<uint8_t>(adc_temp3.read()*3.3f*100.0f);
        
        lcd.printf("T1=%02d, T2=%02d\n", temp1, temp2);
        lcd.printf("T3=%02d, SP=%02d\n", temp3, tempSetValue);
        
        
        if(tempUp == 0) tempSetValue++;
        if(tempDown == 0) tempSetValue--;
        if(onOff == 0) fanOn = !fanOn;
        //if(temp1 > tempSetValue && fanOn) {
        //    fan.write(fanDutyCycle);
        //} else {
        //    fan.write(0.0);
        //}
        led = !led;
        wait(0.020);
    }
}
