#include "mbed.h"
#include "Gamepad.h"
#include "N5110.h"
#include "Engine.h"

#define LEVEL_ONE 2

struct UserInput {
    Direction d;
    float mag;
};

N5110 lcd(PTC9,PTC0,PTC7,PTD2,PTD1,PTC11);  // LCD pin connections.
Gamepad pad;                                // Gamepad object.
Engine engine;                              // Engine object.


/** Initialize
*   
*   Initializes LCD, gamepad, and engine.
*/
void init();


/** Generate
*   
*   Draws all the elements onto the LCD, from the engine.
*/
void generate();


/** Welcome Screen
*   
*   Prints the welcome message to the LCD, and waits for the start button to be pressed
*   to start the game.
*/
void welcome();


int main()
{
    int fps = 14;       // Framerate.

    init();             // Initialization.
    welcome();          // Welcome screen.
    wait(1.0f/fps);  
    
    
    // Game loop:
    while (1) {         
        engine.read_input(pad);         // Reads gamepad input to log changes in analog stick movement.
        engine.check_all(lcd, pad);     // Checking method for all the elements, from the engine.
        engine.update_all(lcd, pad);    // Updating method for all the elements, from the engine.
        generate();                     // Drawing.
        engine.shoot_rocket(lcd, pad);  // Rocket shooting method, from the engine.
        engine.shoot_star(lcd, pad);    // Star shooting method, from the engine.
        lcd.refresh();
        wait(1.0f/fps);
    }
}


// Initialization:

void init()
{
    lcd.init();     // LCD initialization.
    pad.init();     // Gamepad initialization.
    engine.init(LEVEL_ONE, lcd, pad, 0, 0, 3, true, 3);     // Engine initialization, using initial values for variables.
}


// Draws everything:

void generate()
{
    lcd.clear();  
    engine.draw_all(lcd);   // Draws all the elements to the LCD screen, from the engine.   
    lcd.refresh();
}


// Draws the welcome screen:

void welcome() {
    
    lcd.printString("   NEMESIS    ",0,0);
    lcd.printString("A&B: shoot",0,2);
    lcd.printString("R&L: LCD mode",0,3);
    lcd.printString("START: pause",0,4);
    lcd.printString(" Press Start! ",0,5);
    
    lcd.refresh();

    while ( pad.check_event(Gamepad::START_PRESSED) == false) {
        wait(0.1);      // Waits till the start button is pressed.
    }
}