#include "Stats.h"

Stats::Stats()
{
}

Stats::~Stats()
{
}


// Draws initial inner and outer borders to the LCD:

void Stats::draw_grid(N5110 &lcd)
{
    lcd.drawRect(0, 0, WIDTH, HEIGHT-8, FILL_TRANSPARENT);  // Outer border.
    lcd.drawLine(WIDTH-1, HEIGHT-8, WIDTH-1, HEIGHT, 1);    // Health border, right side.
    lcd.drawLine(WIDTH-11, HEIGHT-8, WIDTH-11, HEIGHT, 1);  // Health border, left side.
    lcd.drawLine(18, HEIGHT-1, WIDTH, HEIGHT-1, 1);         // Bottom border.
    lcd.drawLine(18, HEIGHT-8, 18, HEIGHT, 1);              // Wave counter border.
}


// Draws the wave counter onto the LCD:

void Stats::draw_wave_counter(N5110 &lcd, int wave_counter)
{
    char buffer[14];
    int length = sprintf(buffer,"%2d",wave_counter);
    lcd.printString(buffer,0,5);    // Draws constantly-updating value for waves survived onto the bottom left corner of the grid.
}


// Draws the health bar heart onto the LCD (initially empty):

void Stats::draw_health(N5110 &lcd)
{
    lcd.drawLine(76,40,77,40,1);
    lcd.drawLine(79,40,80,40,1);
    lcd.drawLine(75,41,75,43,1);
    lcd.drawLine(81,41,81,43,1);
    lcd.setPixel(78,41);
    lcd.setPixel(76,44);
    lcd.setPixel(80,44);
    lcd.setPixel(77,45);
    lcd.setPixel(79,45);
    lcd.setPixel(78,46);
}


// Draws the first rocket onto the LCD:

void Stats::draw_rocket1(N5110 &lcd, int state)
{
    // State is input when method is used:
    lcd.drawLine(27, HEIGHT-3, 30, HEIGHT-3, state);
    lcd.drawLine(28, HEIGHT-4, 40, HEIGHT-4, state);
    lcd.drawLine(29, HEIGHT-5, 41, HEIGHT-5, state);
    lcd.drawLine(28, HEIGHT-6, 40, HEIGHT-6, state);
    lcd.drawLine(27, HEIGHT-7, 30, HEIGHT-7, state);
}


// Draws the second rocket onto the LCD:

void Stats::draw_rocket2(N5110 &lcd, int state)
{
    // State is input when method is used:
    lcd.drawLine(42, HEIGHT-3, 45, HEIGHT-3, state);
    lcd.drawLine(43, HEIGHT-4, 55, HEIGHT-4, state);
    lcd.drawLine(44, HEIGHT-5, 56, HEIGHT-5, state);
    lcd.drawLine(43, HEIGHT-6, 55, HEIGHT-6, state);
    lcd.drawLine(42, HEIGHT-7, 45, HEIGHT-7, state);
}


// Draws the third rocket onto the LCD:

void Stats::draw_rocket3(N5110 &lcd, int state)
{
    // State is input when method is used:
    lcd.drawLine(57, HEIGHT-3, 60, HEIGHT-3, state);
    lcd.drawLine(58, HEIGHT-4, 70, HEIGHT-4, state);
    lcd.drawLine(59, HEIGHT-5, 71, HEIGHT-5, state);
    lcd.drawLine(58, HEIGHT-6, 70, HEIGHT-6, state);
    lcd.drawLine(57, HEIGHT-7, 60, HEIGHT-7, state);
}


// Draws the star onto the LCD:

void Stats::draw_star(N5110 &lcd, int state)
{
    // State is input when method is used:
    lcd.drawLine(20, HEIGHT-6, 24, HEIGHT-6, state);
    lcd.drawLine(20, HEIGHT-4, 24, HEIGHT-4, state);
    lcd.drawLine(21, HEIGHT-3, 21, HEIGHT-7, state);
    lcd.drawLine(23, HEIGHT-3, 23, HEIGHT-7, state);
    lcd.setPixel(20,41);
    lcd.setPixel(20,45);
    lcd.setPixel(24,41);
    lcd.setPixel(24,45);
}


// Checks and draws the health bar (for high health):

void Stats::check_health_high(N5110 &lcd, int collisions)
{
    // Collisions is input and checked when method is used:
    if (collisions == 0) 
    {   
        lcd.drawLine(76,41,80,41,1);
        lcd.drawLine(76,42,80,42,1);
        lcd.drawLine(76,43,80,43,1);
        lcd.drawLine(77,44,79,44,1);
        lcd.setPixel(78,45);
    }
    else if (collisions == 1) 
    {
        lcd.drawLine(76,42,80,42,1);
        lcd.drawLine(76,43,80,43,1);
        lcd.drawLine(77,44,79,44,1);
        lcd.setPixel(78,45);
    }
}


// Checks and draws the health bar (for low health):

void Stats::check_health_low(N5110 &lcd, int collisions)
{
    // Collisions is input and checked when method is used:
    if (collisions == 2) 
    {
        lcd.drawLine(76,43,80,43,1);
        lcd.drawLine(77,44,79,44,1);
        lcd.setPixel(78,45);
    }
    else if (collisions == 3) 
    {
        lcd.drawLine(77,44,79,44,1);
        lcd.setPixel(78,45);
    }
    else if (collisions == 4)
    {
        lcd.setPixel(78,45);
    }
}


// Checks and draws the rockets:

void Stats::check_rocket(N5110 &lcd, int ammo)
{
    // Ammo is input and checked when method is used:
    if (ammo == 3) {
        draw_rocket1(lcd, 1);
        draw_rocket2(lcd, 1);
        draw_rocket3(lcd, 1);
    } else if (ammo == 2) {
        draw_rocket1(lcd, 1);
        draw_rocket2(lcd, 1);
        draw_rocket3(lcd, 2);
    } else if (ammo == 1) {
        draw_rocket1(lcd, 1);
        draw_rocket2(lcd, 2);
        draw_rocket3(lcd, 2);
    } else if (ammo == 0) {
        draw_rocket1(lcd, 2);
        draw_rocket2(lcd, 2);
        draw_rocket3(lcd, 2);
    }
}


// Checks and draws the star:

void Stats::check_star(N5110 &lcd, bool star)
{
    // Star is input and checked when method is used:
    if (star == true) 
    {
        draw_star(lcd, 1);
    } 
    else 
    {
        draw_star(lcd, 2);
    }
}