#ifndef ROCKET_H
#define ROCKET_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Friendly.h"

/** Rocket Class
@brief Used for generating the rocket (first weapon type) in the Nemesis game. Includes drawing functions. 
@brief Incorporates N5110.h file by Craig A. Evans.

@brief Revision 1.0

@author Musallam M. M. Bseiso
@date   3rd May 2017
*/


class Rocket
{

public:

    /// Constructors and destructors:
    Rocket();
    ~Rocket();
    
    
    ////////////////////////////////
    //////// PUBLIC VARIABLES 
    ////////////////////////////////
    
    
    /** Initialize Rocket
    *   
    *   Initializes rocket x & y positions.
    */
    void init(int x, int y);
    
    
    /** Draw Rocket
    *   
    *   Draws the rocket onto the LCD, in accordance with the parameters initialized in the "init" method.
    *   @param N5110 - nokia LCD library
    *   @param lcd - pointer to nokia LCD library
    */
    void draw(N5110 &lcd);
    
    
private:


    ////////////////////////////////
    //////// PRIVATE VARIABLES
    ////////////////////////////////
    
    
    /// Integer variables to store the x and y coordinates of the friendly ship:
    int _x;
    int _y;
    
};

#endif