#include "Friendly.h"

Friendly::Friendly()
{
}

Friendly::~Friendly()
{
}


// Initializion method:

void Friendly::init()
{
    _x = 2;         // Starting x position (fixed).
    _y = 18;        // starting y position (fixed, centre).
}


// Draws friendly ship onto LCD:

void Friendly::draw(N5110 &lcd)
{
    lcd.drawLine(_x,_y,_x,_y+5,1);
    lcd.drawLine(_x+1,_y,_x+3,_y,1);
    lcd.drawLine(_x+1,_y+5,_x+3,_y+5,1);
    lcd.drawLine(_x+4,_y+1,_x+5,_y+1,1);
    lcd.drawLine(_x+4,_y+4,_x+5,_y+4,1);
    lcd.drawLine(_x+6,_y+2,_x+6,_y+3,1);
}


// Updates friendly ship's position based on basic vertical and horizontal movement:

void Friendly::update_basic(Direction d,float mag)
{
    _speed = int(mag*4.0f);     // Speed of movement depends on analog stick (mag).
    
    if (d == N) {               // If direction is north, move upwards (y).
        _y-=_speed;
    } else if (d == S) {        // If direction is south, move downwards (y).
        _y+=_speed;
    } else if (d == W) {        // If direction is west, move to the left (x).
        _x-=_speed;
    } else if (d == E) {        // If direction is east, move to the right (x).
        _x+=_speed;
    }
}


// Updates friendly ship's position based on diagonal movement:

void Friendly::update_diagonal(Direction d,float mag)
{
    _speed = int(mag*4.0f);
    
    if (d == NW) {              // If direction is northwest, move upwards (y) and to the left (x).
        _y-=_speed;
        _x-=_speed;
    } else if (d == NE) {       // If direction is northeast, move upwards (y) and to the right (x).
        _y-=_speed;
        _x+=_speed;
    } else if (d == SW) {       // If direction is southwest, move downwards (y) and to the left (x).
        _y+=_speed;
        _x-=_speed;
    } else if (d == SE) {       // If direction is southeast, move downwards (y) and to the right (x).
        _y+=_speed;
        _x+=_speed;
    }
}


// Prevents friendly ship from going off-screen:

void Friendly::check_pos() 
{    
    if (_y < 1) {   // Prevents ship from moving past upper gridline.
        _y = 1;
    }
    
    if (_y > 33) {  // Prevents ship from moving past lower gridline.
        _y = 33;
    }
    
    if (_x < 1) {   // Prevents ship from moving past left gridline.
        _x = 1;
    }
    
    if (_x > 78) {  // Prevents ship from moving past right gridline.
        _x = 78;
    }
}


// Obtains friendly's current position:

Vector2D Friendly::get_pos() 
{
    Vector2D p = {_x,_y};
    return p;    
}