#ifndef ENEMY6_H
#define ENEMY6_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Friendly.h"

/** Enemy6 Class
@brief Used for generating the sixth enemy ship in the Nemesis game. Includes drawing and updating functions. 
@brief Incorporates N5110.h file by Craig A. Evans.

@brief Revision 1.0

@author Musallam M. M. Bseiso
@date   3rd May 2017
*/


class Enemy6
{

public:

    /// Constructor and destructor:
    Enemy6();
    ~Enemy6();
    
    
    ////////////////////////////////
    //////// PUBLIC METHODS
    ////////////////////////////////
    
    
    /** Initialize Enemy6
    *   
    *   Initializes sixth enemy ship x (random) & y (fixed) positions, as well as speed.
    */
    void init(int speed);
    
    
    /** Draw Enemy6
    *   
    *   Draws the sixth enemy ship onto the LCD, in accordance with the parameters initialized in the "init" method.
    *   @param N5110 - nokia LCD library
    *   @param lcd - pointer to nokia LCD library
    */
    void draw(N5110 &lcd);
    
    
    /** Update Enemy6
    *   
    *   Updates the sixth enemy ship's x and y position. X and y positions are altered by adding speeds.
    */
    void update();


    /** Get Enemy6 Position
    *
    *   Obtains the position (x and y coordinates) of the sixth enemy ship at any given time, into a two-dimensional vector.
    *   @returns p - the Vector2D of the parameters
    */
    Vector2D get_pos();
    
private:


    ////////////////////////////////
    //////// PRIVATE VARIABLES
    ////////////////////////////////
    

    /// Vector2D that stores two speeds, one for x and one for y.
    Vector2D _velocity;
    
    /// Integer variables to store the x and y coordinates of the friendly ship:
    int _x;
    int _y;
    
};
#endif