#ifndef ENEMY5_H
#define ENEMY5_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Friendly.h"

/** Enemy5 Class
@brief Used for generating the fifth enemy ship in the Nemesis game. Includes drawing and updating functions. 
@brief Incorporates N5110.h file by Craig A. Evans.

@brief Revision 1.0

@author Musallam M. M. Bseiso
@date   3rd May 2017
*/


class Enemy5
{

public:

    /// Constructor and destructor:
    Enemy5();
    ~Enemy5();
    
    
    ////////////////////////////////
    //////// PUBLIC METHODS
    ////////////////////////////////
    
    
    /** Initialize Enemy5
    *   
    *   Initializes fifth enemy ship x (random) & y (fixed) positions, as well as speed.
    */
    void init(int speed);
    
    
    /** Draw Enemy5
    *   
    *   Draws the fifth enemy ship onto the LCD, in accordance with the parameters initialized in the "init" method.
    *   @param N5110 - nokia LCD library
    *   @param lcd - pointer to nokia LCD library
    */
    void draw(N5110 &lcd);
    
    
    /** Update Enemy5
    *   
    *   Updates the fifth enemy ship's x and y position. X and y positions are altered by adding speeds.
    */
    void update();


    /** Get Enemy5 Position
    *
    *   Obtains the position (x and y coordinates) of the fifth enemy ship at any given time, into a two-dimensional vector.
    *   @returns p - the Vector2D of the parameters
    */
    Vector2D get_pos();
    
private:


    ////////////////////////////////
    //////// PRIVATE VARIABLES
    ////////////////////////////////
    

    /// Vector2D that stores two speeds, one for x and one for y.
    Vector2D _velocity;
    
    /// Integer variables to store the x and y coordinates of the friendly ship:
    int _x;
    int _y;
    
};
#endif