#ifndef ENEMY2_H
#define ENEMY2_H

#include "mbed.h"
#include "N5110.h"
#include "Gamepad.h"
#include "Friendly.h"

/** Enemy2 Class
@brief Used for generating the second enemy ship in the Nemesis game. Includes drawing and updating functions. 
@brief Incorporates N5110.h file by Craig A. Evans.

@brief Revision 1.0

@author Musallam M. M. Bseiso
@date   3rd May 2017
*/


class Enemy2
{

public:

    /// Constructor and destructor:
    Enemy2();
    ~Enemy2();
    
    
    ////////////////////////////////
    //////// PUBLIC METHODS
    ////////////////////////////////
    
    
    /** Initialize Enemy2
    *   
    *   Initializes second enemy ship x (random) & y (fixed) positions, as well as speed.
    */
    void init(int speed);
    
    
    /** Draw Enemy2
    *   
    *   Draws the second enemy ship onto the LCD, in accordance with the parameters initialized in the "init" method.
    *   @param N5110 - nokia LCD library
    *   @param lcd - pointer to nokia LCD library
    */
    void draw(N5110 &lcd);
    
    
    /** Update Enemy2
    *   
    *   Updates the second enemy ship's x and y position. X and y positions are altered by adding speeds.
    */
    void update();


    /** Get Enemy2 Position
    *
    *   Obtains the position (x and y coordinates) of the second enemy ship at any given time, into a two-dimensional vector.
    *   @returns p - the Vector2D of the parameters
    */
    Vector2D get_pos();
    
private:


    ////////////////////////////////
    //////// PRIVATE VARIABLES
    ////////////////////////////////
    

    /// Vector2D that stores two speeds, one for x and one for y.
    Vector2D _velocity;
    
    /// Integer variables to store the x and y coordinates of the friendly ship:
    int _x;
    int _y;
    
};
#endif