#include "MCP.h"
#include "mbed.h"
#include "MCP23017.h"

MCP::MCP(PinName sda, PinName scl, uint8_t device_address)
    :i2c(sda, scl), mcp(i2c, device_address) 
{
    _iodir_data.all = 0xffff;
    _pull_data.all  = 0xffff;
    _read_data.all  = 0x0000;
    _write_data.all = 0x0000;
}

void MCP::PinMode(uint8_t pin, pin_mode mode)
{
    if(mode == OUTPUT) {
        _iodir_data.all &= ~(0x0001 << pin);
    } else if(mode == INPUT) {
        _iodir_data.all |= (0x0001 << pin);
    } else if(mode == INPUT_PULLUP) {
        _iodir_data.all |= (0x0001 << pin);
        _pull_data.all |= (0x0001 << pin);
    }
}

void MCP::Write(uint8_t pin, bool signal)
{
    if(signal == 1) {
        _write_data.all |= (0x0001 << pin);
    } else {
        _write_data.all &= ~(0x0001 << pin);
    }
}

bool MCP::Read(uint8_t pin)
{
    return (_read_data.all >> pin) & 0x01;
}
        
void MCP::Update(void) {
    i2c.frequency(100000);
    char data[2] = {GPPUA, 0xff};
    int lost = i2c.write(0x40, data, 2);
    if(lost) {
        i2c.start();
    }
    mcp.direction(PORT_A, _iodir_data.port.port_A);
    mcp.direction(PORT_B, _iodir_data.port.port_B);
    mcp.configurePullUps(PORT_A, _pull_data.port.port_A);
    mcp.configurePullUps(PORT_B, _pull_data.port.port_B);
    _read_data.port.port_A = mcp.read(PORT_A);
    _read_data.port.port_B = mcp.read(PORT_B);
    mcp.write(PORT_A, _write_data.port.port_A);
    mcp.write(PORT_B, _write_data.port.port_B);
    
}
    