#ifndef MBED_KS0713_SPI_H
#define MBED_KS0713_SPI_H

#define MBED_KS0713_SPI_WIDTH  100
#define MBED_KS0713_SPI_HEIGHT  32


#include "mbed.h"
//
// KS0713 SPI driver for aitendo 100x32 LCD module.
//
// This driver is based on Tony Beck's KS0713 library. Thank you.
//
//  Website: http://www.aitendo.co.jp/product/3127
//
// LCD module pin assign
//
//    1.VSS(GND)
//    2.VDD(3.3V)
//    3.CS1B
//    4.CS2(tie off to H)
//    5.RS(1:data, 0:command)
//    6.RD(tie off to H or L)
//    7.WR(tie off to H or L)
//    8.PS(1:parallel, 0:serial) (tie off to L)
//    9.RESETN
//    10.MI(1:6800, 0:8080) (tie off to H or L)
//    11.DB7(serial data, MSB 1st)
//    12.DB6(serial clock)
//    13.DB5 NC
//    14.DB4 NC
//    15.DB3 NC
//    16.DB2 NC
//    17.DB1 NC
//    18.DB0 NC
//    19.NC


class KS0713_SPI : public Stream {
public:
    KS0713_SPI(PinName mosi, PinName sclk, PinName cs1b, PinName rs, PinName rstb);
    void init();
    void clear();
    void fill();
    void update();
    void locate(int x, int y);
    void line(int x1, int y1, int x2, int y2);
private:
    SPI _spi;
    DigitalOut _cs1b;
    DigitalOut _rs;
    DigitalOut _rstb;
    int _x,_y;


    void writeCommand(unsigned char);
    void writeData(unsigned char);

    unsigned char vram[MBED_KS0713_SPI_WIDTH][MBED_KS0713_SPI_HEIGHT/8];

protected:
    virtual int _putc(int value);
    virtual int _getc();


};

#endif