#include "IO3714.h"

IO3714::IO3714(PinName mosi, PinName sclk, PinName clr_n, PinName stb_n)
        : _spi(mosi,NC,sclk), _clr_n(clr_n), _stb_n(stb_n) {
    _clr_n=0;
    _stb_n=0;
    _spi.format(12,0);
    _spi.frequency(48000000);
    _clr_n=1;
}

void IO3714::write(unsigned int data) {


    _spi.write((data>>12) & 0xFFF  );
    _spi.write(data & 0xFFF );
    _stb_n=0;
    _stb_n=1;

}
