/* mbed library for the ST NUCLEO board L152RE 
 * to change the CPU clock to 32 MHz
 * A pll clock of 96 MHz is used to enable USB  
 *
 * Copyright (c) 2014 Peter Drescher - DC2PD
 * Released under the MIT License: http://mbed.org/license/mit
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 
 
#ifndef MBED_ST_L152_32MHZ_H
#define MBED_ST_L152_32MHZ_H

/** Setup cpu speed to 32 MHz
 *
 * @code
 * #include "mbed.h"
 * #include "ST_L152_32MHZ.h"
 *
 * // place the init before other code to ensure right timing of other objects !
 * L152_init32 myinit(0);   // use the internal oscillator 
 * 
 */

typedef enum { OK = 0 , PLL_ERR, EXT_ERR }ClockStatus;

class L152_init32
{
public:
 /** Create a L152_init32 object to change the clock
   * @param external = 0 use internal oscillator
   * @param external = 1 use external 8 MHz crystal - you have to add some comonents to the pcb !
*/
L152_init32(unsigned int external);
ClockStatus Status;

protected:
// do the magic ;-)
ClockStatus setup_clock_32MHZ(int external);
};

#endif


