/* mbed Microcontroller Library
 * Copyright (c) 2006-2013 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "mbed.h"
//#include "BatteryService.h"
#include "mbed.h"
#include <FileBase.h>
#include "SDFileSystem.h"
#include "rtos.h"
#include <Thread.h>
#include <stdio.h>
/* C++ header files */
#include <string>
#include <vector>
/* C header files */
#include <cstdio>
#include <cstring>
#include <cstdlib>
//#include "ST_L152_32MHZ.h"
//L152_init32 myinit(0);   // use the internal oscillator


using namespace std;

// DEFINE
#define NBFICHIERPOSSIBLE 1000

// STRUCTURE
typedef struct {

    AnalogIn * laPin;
    DigitalOut * laPinEco;
//    string leTypeGPIO; // Num ou Anal
//    string leTypeE; // Entrée ou Sortie
    int laFrequence;
    int leModeEco; // Si -1 pas de mode eco sinon numero de pin
    std::string * leNom;
    std::string * Path;
} laSonde;

typedef struct {
    laSonde * saSonde;
    float saMesure;
    int sonTemps;
} laMesure;

// VAR GLOBAL
Mail<laMesure, 30> mail_box;
Serial pc1(USBTX, USBRX);
//SDFileSystem sd(PB_15, PB_14, PB_13, D4, "sd"); // MOSI, MISO, SCK, CS
SDFileSystem sd(D11, D12, D13, D4, "sd"); // MOSI, MISO, SCK, CS
Timer t;
volatile int a=0;
Mutex mtx;

PinName analog[6] = { A0, A1,A2,A3,A4,A5 };
PinName digital[16] = {D0,D1,D2,NC,NC,NC,D6,D7,D8,D9,D10,NC,NC,NC,D14,D15 };

/**
* Récuperation de data
*/
void getdata(void const *args)
{
    laSonde * saSonde = (laSonde*) args;
    while(1) {
        //mtx.lock();
        if(saSonde->leModeEco != -1)
            saSonde->laPinEco->write(1);
        laMesure *message = mail_box.alloc();
        message->saSonde = saSonde;
        message->saMesure = saSonde->laPin->read();
        message->sonTemps = t.read();
        mail_box.put(message);
        if(saSonde->leModeEco != -1)
            saSonde->laPinEco->write(0);
        a++;
        //mtx.unlock();
        Thread::wait(saSonde->laFrequence/100);
        
    }
}

void configuration()
{
    t.start();
    FILE *fp = fopen("/sd/config.csv", "r");  // Open "out.txt" on the local file system for writing
    if(fp == NULL) {
        pc1.printf("Le fichier de configuration n'existe pas");
    } else {

        char buf [128];
                  //  mtx.lock(); // init du mutex
        while(1) {
            if((fgets(buf, 64, fp)) == NULL)
                break;
            int a =0;
            char delim[] = ",";
            char* token;
            laSonde * saSonde = (laSonde * ) malloc(sizeof(laSonde));
            for (token = strtok(buf, delim); token; token = strtok(NULL, delim)) {
                switch(a) {
                    case 0 : { // Nom de la pin
                        printf("%s \n",token);
                        saSonde->leNom = new string(token);
                        saSonde->Path =  new string(token);
                        saSonde->Path->insert(0,"/sd/");
                        mkdir(saSonde->Path->c_str(),0777);
                        saSonde->Path->insert(saSonde->Path->size(),"/");
                        saSonde->Path->insert(saSonde->Path->size(),token);
                        break;
                    }
                    case 1 : { // Numéro de Pin
                        saSonde->laPin = new AnalogIn(analog[atoi((const char*)token)]);
                        break;
                    }
                    case 2 : { // Type Analogique ou Numerique
                        //saSonde->leTypeGPIO = laLigne.at(2); // Num ou Anal
                        break;
                    }
                    case 3 : { // Entrée ou Sortie
                        //saSonde->leTypeE = laLigne.at(3); // Entrée ou Sortie

                        break;
                    }
                    case 4 : { // Frequence pour Sortie
                        saSonde->laFrequence = atoi((const char*)token);
                        break;
                    }
                    case 5 : { // Mode éco
                        saSonde->leModeEco = atoi((const char*)token); // Si -1 pas de mode eco
                        break;
                    }
                    default : {
                        printf("error parsing\n)");
                    }

                }
                a++;
            }

            if(saSonde->leModeEco != -1)
                saSonde->laPinEco = new DigitalOut(digital[saSonde->leModeEco]);
            printf("created thread \n");
            Thread* unThread = new  Thread(getdata,saSonde);
        }//mtx.unlock(); // init du mutex
    }   
 
}

int main(void)
{
#if 1
    FILE *fp;
    char cc[200];
    configuration();
    while (true) {
        osEvent evt = mail_box.get();
        if (evt.status == osEventMail) {
           // mtx.lock();
            a--;
            laMesure *mail = (laMesure*)evt.value.p;
            fp = fopen(mail->saSonde->Path->c_str(), "a");
            if (fp == 0) {
                printf("file write failed: %s\n", mail->saSonde->Path->c_str());
            } else {
                sprintf(cc,"%d,%f\n",mail->sonTemps,mail->saMesure);
                printf("%d,%f\n",mail->sonTemps,mail->saMesure);
                fwrite (cc , sizeof(char), sizeof(cc), fp);
            }
            fclose(fp);
            mail_box.free(mail);
          //  mtx.unlock();
        }
    }
#else
    wait(3);
    AnalogIn  laPin(A0);
    AnalogOut  aout(A2);
    while (1) {
        // change the voltage on the digital output pin by 0.1 * VCC
        //  and print what the measured voltage should be (assuming VCC = 3.3v)
        for (float i = 0.0f; i < 1.0f; i += 0.1f) {
            aout = i;
            printf("aout = %1.2f volts", aout.read() * 3.3f);
            wait(0.4);
            pc1.printf("Test : %f volts \n",(laPin.read()*(3.33  )) );
            wait(5);
        }
    }
#endif
}

