#ifndef Drive_hpp
#define Drive_hpp

#include "mbed.h"
#include "serial.h"
#include "Servo.h"

class Drive : public Rasp{
    public:
        Drive(PinName CAN_TX, PinName CAN_RX);
        void setVelocity();
        void calcWheelVelocity();
        void dribble_set();
        void setMotVel();
        void initCAN();
        void can_send();
        int masuo_send();
       
    private:
        typedef struct {
            union{
                signed short Vel_short;
                struct{
                    signed short L:8;
                    signed short H:8;
                }Vel_char;
            }Mot0Order;
    
            union{
                signed short Vel_short;
                struct{
                    signed short L:8;
                    signed short H:8;
                }Vel_char;
            }Mot1Order;
    
            union{
                signed short Vel_short;
                struct{
                    signed short L:8;
                    signed short H:8;
                }Vel_char;
            }Mot2Order;
    
            union{
                signed short Vel_short;
                struct{
                    signed short L:8;
                    signed short H:8;
                }Vel_char;
            }Mot3Order;
    
        } OrderMotVel;

        OrderMotVel order;
        
        Ticker can_Timer;
        char send_motvel_data[8];
        CAN canMBED;
        float M[4];
        float dribble_power;
        DigitalOut LED;
        Servo servo;
        int count;
};

#endif