#include "mbed.h"
#include "FXOS8700Q.h"
#include "FXAS21000.h"
#include "hcsr04.h"
#include "LED_Bar.h"
#include <stdio.h>
#include <string.h>
//Colours for printf
#define cyan "\033[0;36m" /* 0 -> normal; 36 -> cyan */
#define green "\033[4;32m" /*4 -> underline ; 32 -> green */
#define blue "\033[9;34m" /*9 -> strike ; 34 -> blue */
#define KWHT "\x1B[37m"
#define none "\033[0m" /* to flush the previous property */

//IO declarations
Serial pc(USBTX, USBRX); //PC UART
//DigitalOut led1(LED1);
DigitalOut GREEN(LED2); //Input Mode
DigitalOut BLUE(LED3); //output mode
DigitalIn sw2(SW2); //INPUT MODE SELECT
DigitalIn sw3(SW3); //Output mode select
//Bluetooth module declaration
Serial HC06(PTC15, PTC14); //BT TX, RX
char snd[512], rcv[1000]; //send and receive buffer

    I2C i2c(PTE25, PTE24);
    Serial pc(USBTX,USBRX);
    FXOS8700QAccelerometer acc(i2c, FXOS8700CQ_SLAVE_ADDR1);    // Configured for the FRDM-K64F with onboard sensors
    FXOS8700QMagnetometer mag(i2c, FXOS8700CQ_SLAVE_ADDR1);
    FXAS21000 gyro(D14,D15);
    HCSR04 usensor1(D8,D9);                     //ECHO Pin=D9, TRIG Pin=D8
    HCSR04 usensor2(D7,D6);                     //ECHO Pin=D7, TRIG Pin=D6
    LED_Bar bar(D5,D4);
    DigitalOut buzzer(D2);
    int buzz_on=1, buzz_off=0;

    int main(void)
    {
        int num = 0;
        int distance1, distance2;
        int led_speed;
        float dist_remaining1, dist_percent1, dist_remaining2, dist_percent2;
        char snd[255],rcv[1000];                    //snd: send command to ESP8266
                                            //rcv: receive response from ESP8266

        //Ultrasound Sensor (HC-SR04) #1 Initialization
        int a = 30;
        float gyro_data[3];
        motion_data_units_t acc_data, mag_data;
        motion_data_counts_t acc_raw, mag_raw;
        float faX, faY, faZ, fmX, fmY, fmZ, tmp_float;
        int16_t raX, raY, raZ, rmX, rmY, rmZ, tmp_int;
        acc.enable();
        mag.enable();
        usensor1.start();
            wait_ms(500);
        //DigitalOut Red(LED1);
//        Red=1;
//        DigitalOut Blue(LED3);
//        DigitalOut Green(LED2);
//        Blue=1;
//        Green=1;
        
        while (true) {
            // counts based results
            acc.getAxis(acc_raw);
            mag.getAxis(mag_raw);
            acc.getX(raX);
            acc.getY(raY);
            acc.getZ(raZ);
            mag.getX(rmX);
            mag.getY(rmY);
            mag.getZ(rmZ);
            // unit based results
            acc.getAxis(acc_data);
            mag.getAxis(mag_data);
            acc.getX(faX);
            acc.getY(faY);
            acc.getZ(faZ);
            mag.getX(fmX);
            mag.getY(fmY);
            mag.getZ(fmZ);
           pc.printf("FXOSQ8700Q ACC: X=%1.4f   Y=%1.4f   Z=%1.4f", acc.getX(faX),acc.getY(faY),acc.getZ(faZ));
           pc.printf("  MAG: X=%4.1f   Y=%4.1f   Z=%4.1f\r\n", mag.getX(fmX),mag.getY(fmY), mag.getZ(fmZ));
           gyro.ReadXYZ(gyro_data);
           pc.printf("FXAS21000  Gyro: X=%6.2f   Y=%6.2f    Z=%6.2f\r\n", gyro_data[0],gyro_data[1], gyro_data[2]);
           
           
           
        
    //Calculating Distance Percentage Remaining for Sensor # 1
            distance1 = usensor1.get_dist_cm();
            dist_remaining1 = a-distance1;
            dist_percent1 = (dist_remaining1/30)*100;
//        
    ////LED and Tera Term Output
            // if (distance1<30 && distance2<30) {
////            
              // pc.printf("You are colse!\n\r");}
//                    pc.putc(pc.getc() + 1);}
//            //printf("Percent remaining: %f\r", dist_percent1 && dist_percent2);
//        } else {
//            //GLed = 1;
////            BLed = 1;
////            RLed = 0;
//            pc.printf("You are far!\n\r"); while(1) {
//                    pc.putc(pc.getc() + 1);}
//            }
          
           if((abs(acc.getX(faX)) > 1.5 || abs(acc.getZ(faZ)) > 1.3 || abs(acc.getY(faY)) > 0.1) || (distance1>30 && distance2>30)) 
           {
            
            //Red = 0;
//            Blue = 1;
//            Green = 1;
            
           // pc.printf("Going too fast!\n\r"); //while(1) {
           // pc.putc(pc.getc() + 1);}
            
            buzzer=buzz_on;
            wait(0.5);
            buzzer=buzz_off;
            wait(0.5);
            
            for(led_speed=0; led_speed<=10; led_speed++){
                bar.setLevel(led_speed);
                wait(0.001);
                }
                
                HC06.printf("\nWe are in danger, sending sms now\n");
\

            } 
            
            
            else{
                
                //Red = 1;
//                Green = 0;
//                Blue = 1;
                     
//                    pc.printf("You are safe!\n\r"); //while(1) {
//                    pc.putc(pc.getc() + 1);}
                    
                for(led_speed=0; led_speed<=10; led_speed++){
                    bar.setLevel(led_speed);
                    wait(1);
                    }
                           
                };
            wait(1.0f);
        }
    }