#include "mbed.h"
#include "C12832.h"
#include <string>
C12832 lcd(SPI_MOSI, SPI_SCK, SPI_MISO, p8, p11);
InterruptIn btn(p8);
// Add a yellow LED on pin 13 and initialize it to 1 (ON)
DigitalOut yellowLed(p5, 1);
// Add a red LED on pin 8 and initialize it to 0 (OFF)
DigitalOut redLed(p6, 0);
string drivermsg="10 DISCOUNT ON YOUR FULL TANK AT SP RWANDA";
string pedestrianmsg="BUY 2 COFFEES FOR THE PRICE OF 1. ONLY AT CAMELIA";
// Add a speaker
PwmOut speaker(p21);
void play_tone(float frequency, float volume, int interval, int rest) {
    speaker.period(1.0 / frequency);
    speaker = volume;
    printf("speak now");
    wait_ms(interval);
    speaker = 0.0;
    wait(rest);
}
void displayLCD(string msg){
    lcd.cls();
    lcd.locate(0, 0);
    lcd.printf(msg.c_str());
}
void control_leds() {
    int yellowBlinkingTimeCounter = 0;
    int pedestrianTimeCounter = 0;
    
    displayLCD(pedestrianmsg);
    while (yellowBlinkingTimeCounter < 5) {
        yellowLed = !yellowLed; // inverse the state of the LED
        yellowBlinkingTimeCounter++; // Increment counter
        wait_ms(500);
        }
        yellowLed = 0; // Yellow LED is OFF
        redLed = !yellowLed; // Inverse the state of yellow LED
        
        displayLCD(drivermsg);
        while (pedestrianTimeCounter < 6) {
            pedestrianTimeCounter++;
            play_tone(250, 0.2, 500, 0); // subprogram play sound
             wait_ms(500);
        }
        redLed = yellowLed; 
        yellowLed=!redLed;
       
        displayLCD("13:00:00");
}

int main() {
    displayLCD("13:00:00");
    btn.fall(callback(&control_leds));
    
}
