#include "MicroBit.h"
#include <cstdlib>

MicroBit uBit;
int player_x = 2;
int enemy_x = rand() % 4 + 0;
int enemy_y = 0;

int main()
{
    // Initialise the micro:bit runtime.
    uBit.init();
    while (true)
    {
        uBit.display.clear(); //Refreshes display through each loop
        
        // Setting the player and enemies
        uBit.display.image.setPixelValue(player_x, 4, 255); 
        uBit.display.image.setPixelValue(enemy_x, enemy_y, 255);
        
        // If player hits an enemy, then gameover
        if (enemy_y == 4 && enemy_x == player_x) {
            break;   
        }
        
        // Button events. Player moves left or right
        if (uBit.buttonA.isPressed() && player_x > 0)
        {
            player_x -= 1;   
        }  
        if (uBit.buttonB.isPressed() && player_x < 4)
        {
            player_x += 1;   
        }  
        
        // Enemy moves down the y
        // If enemy is all the way down, random x is given from the top
        enemy_y += 1;
        if (enemy_y > 4){
            enemy_y = 0;
            enemy_x = rand() % 4 + 0;
        }
        // sleep() function to slow down the enemy
        uBit.sleep(250);        
        
    }
    uBit.display.scroll("GAME OVER");   

    release_fiber();
}

