/*******************************************************************************
 * Copyright (c) 2014, 2015 IBM Corp.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * and Eclipse Distribution License v1.0 which accompany this distribution.
 *
 * The Eclipse Public License is available at
 *    http://www.eclipse.org/legal/epl-v10.html
 * and the Eclipse Distribution License is available at
 *   http://www.eclipse.org/org/documents/edl-v10.php.
 *
 * Contributors:
 *    Sam Danbury - initial implementation
 *    Ian Craggs - refactoring to remove STL and other changes
 *    Sam Grove  - added check for Ethernet cable.
 *    Chris Styles - Added additional menu screen for software revision
 *    James Sutton - Mac fix and extra debug
 *    Ian Craggs - add not authorized messages
 *
 * To do :
 *    Add magnetometer sensor output to IoT data stream
 *
 *******************************************************************************/

#include "LM75B.h"
#include "MMA7660.h"
#include "MQTTClient.h"
#include "MQTTEthernet.h"
//#include "C12832.h"
#include "Arial12x12.h"
#include "rtos.h"

#include "MFRC522.h"

// Update this to the next number *before* a commit
#define __APP_SW_REVISION__ "18"

// Configuration values needed to connect to IBM IoT Cloud
#define ORG "nqnqo3"             // For a registered connection, replace with your org
#define ID "0002f7f260cc"                        // For a registered connection, replace with your id
#define AUTH_TOKEN "xXgpv8_f4TM8*h&voy"                // For a registered connection, replace with your auth-token
#define TYPE "mbed-ers4"      // For a registered connection, replace with your type

#define MQTT_PORT 1883
#define MQTT_TLS_PORT 8883
#define IBM_IOT_PORT MQTT_PORT

#define MQTT_MAX_PACKET_SIZE 250

#if defined(TARGET_UBLOX_C027)
#warning "Compiling for mbed C027"
#include "C027.h"
#elif defined(TARGET_LPC1768)
#warning "Compiling for mbed LPC1768"
#include "LPC1768.h"
#elif defined(TARGET_K64F)
#warning "Compiling for mbed K64F"
#include "K64F.h"
#endif


#define SPI_MOSI    p5
#define SPI_MISO    p6
#define SPI_SCK     p7
#define SPI_CS      p21
#define MF_RESET    p8
#define UART_RX     p10
#define UART_TX     p9

//Serial connection to PC for output
Serial pc(p9,p10);
MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, MF_RESET);

bool quickstartMode = true;
char org[11] = ORG;
char type[30] = TYPE;
char id[30] = ID;                 // mac without colons
char auth_token[30] = AUTH_TOKEN; // Auth_token is only used in non-quickstart mode

bool connected = false;
bool mqttConnecting = false;
bool netConnected = false;
bool netConnecting = false;
bool ethernetInitialising = true;
int connack_rc = 0; // MQTT connack return code
int retryAttempt = 0;
int menuItem = 0;

//char  RFID[25]="ECD0D334";
//char* RFID_str = (char*) malloc (2*RfChip.uid.size + 1);
char RFID_new[9];
char RFID_old[9];
char* joystickPos = "CENTRE";
int blink_interval = 0;

char* ip_addr = "";
char* gateway_addr = "";
char* host_addr = "";
int connectTimeout = 1000;

bool tag_EN = true;
bool New_RFID = false ;

// If we wanted to manually set the MAC address,
// this is how to do it. In this example, we take
// the original Mbed Set MAC address and combine it
// with a prefix of our choosing.
/*
extern "C" void $Super$$mbed_mac_address(char *s);
extern "C" void $Sub$$mbed_mac_address(char *s)
{
   char originalMAC[6] = "";
   $Super$$mbed_mac_address(originalMAC);

   char mac[6];
   mac[0] = 0x00;
   mac[1] = 0x08;
   mac[2] = 0xdc;
   mac[3] = originalMAC[3];
   mac[4] = originalMAC[4];
   mac[5] = originalMAC[5];
   memcpy(s, mac, 6);
}
*/

void tagRFID(void const *args)
{
    
    
    while(tag_EN)
    {
        while(  !RfChip.PICC_IsNewCardPresent()) {
                Thread::wait(10); 
                continue;            
        }
        if ( ! RfChip.PICC_ReadCardSerial()) {
                //wait_ms(100);
                //continue;
        }
    
        uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak);
        
        sprintf(RFID_new,"%02X%02X%02X%02X",RfChip.uid.uidByte[0],RfChip.uid.uidByte[1],RfChip.uid.uidByte[2],RfChip.uid.uidByte[3]);
    }
    
    for(int i=0;i<9;i++)
    {
        RFID_old[i]=RFID_new[i];
    }
    
}

void off()
{
    //r = g = b = 1.0;    // 1 is off, 0 is full brightness
}

void red()
{
    //r = 0.7; g = 1.0; b = 1.0;    // 1 is off, 0 is full brightness
}

void yellow()
{
    //r = 0.7; g = 0.7; b = 1.0;    // 1 is off, 0 is full brightness
}

void green()
{
    //r = 1.0; g = 0.7; b = 1.0;    // 1 is off, 0 is full brightness
}


void flashing_yellow(void const *args)
{
    bool on = false;
    while (!connected && connack_rc != MQTT_NOT_AUTHORIZED && connack_rc != MQTT_BAD_USERNAME_OR_PASSWORD) {  // flashing yellow only while connecting
        on = !on;
        if (on)
            yellow();
        else
            off();
        wait(0.5);
    }
}


void flashing_red(void const *args)  // to be used when the connection is lost
{
    bool on = false;
    while (!connected) {
        on = !on;
        if (on)
            red();
        else
            off();
        wait(2.0);
    }
}


void printMenu(int menuItem)
{
    static char last_line1[30] = "", last_line2[30] = "";
    char line1[30] = "", line2[30] = "";

    switch (menuItem) {
        case 0:
            sprintf(line1, "IBM IoT Cloud");
            sprintf(line2, "Scroll with joystick");
            break;
        case 1:
            sprintf(line1, "Go to:");
            sprintf(line2, "http://ibm.biz/iotqstart");
            break;
        case 2:
            sprintf(line1, "Device Identity:");
            sprintf(line2, "%s", id);
            break;
        case 3:
            sprintf(line1, "MQTT Status:");
            if (mqttConnecting)
                sprintf(line2, "Connecting... %d/5", retryAttempt);
            else {
                if (connected)
                    sprintf(line2, "Connected");
                else {
                    switch (connack_rc) {
                        case MQTT_CLIENTID_REJECTED:
                            sprintf(line2, "Clientid rejected");
                            break;
                        case MQTT_BAD_USERNAME_OR_PASSWORD:
                            sprintf(line2, "Invalid username or password");
                            break;
                        case MQTT_NOT_AUTHORIZED:
                            sprintf(line2, "Not authorized");
                            break;
                        default:
                            sprintf(line2, "Disconnected");
                    }
                }
            }
            break;
        case 4:
            sprintf(line1, "Ethernet State:");
            sprintf(line2, ethernetInitialising ? "Initializing..." : "Initialized");
            break;
        case 5:
            sprintf(line1, "Socket State:");
            if (netConnecting)
                sprintf(line2, "Connecting... %d/5", retryAttempt);
            else
                sprintf(line2, netConnected ? "Connected" : "Disconnected");
            break;
        case 6:
            sprintf(line1, "IP Address:");
            sprintf(line2, "%s", ip_addr);
            break;
        case 7:
            sprintf(line1, "Gateway:");
            sprintf(line2, "%s", gateway_addr);
            break;
        case 8:
            sprintf(line1, "App version:");
            sprintf(line2, "%s", __APP_SW_REVISION__);
            break;
        case 9:
            sprintf(line1, "Current Timeout:");
            sprintf(line2, "%d ms", connectTimeout);
            break;
    }

    if (strcmp(line1, last_line1) != 0 || strcmp(line2, last_line2) != 0) {
        //lcd.cls();
        //lcd.locate(0, 0);
        //lcd.printf(line1);
        strncpy(last_line1, line1, sizeof(last_line1));

        //lcd.locate(0,16);
        //lcd.printf(line2);
        strncpy(last_line2, line2, sizeof(last_line2));
    }
}


void setMenu()
{

    /*if (Down)
    {
        joystickPos = "DOWN";
        if (menuItem >= 0 && menuItem < 9)
            printMenu(++menuItem);
    }
    else if (Left)
        joystickPos = "LEFT";
    else if (Click)
        joystickPos = "CLICK";
    else if (Up)
    {
        joystickPos = "UP";
        if (menuItem <= 9 && menuItem > 0)
            printMenu(--menuItem);
    }
    else if (Right)
        joystickPos = "RIGHT";
    else
        joystickPos = "CENTRE";*/
}

void menu_loop(void const *args)
{
    int count = 0;
    while(true) {
        setMenu();
        if (++count % 10 == 0)
            printMenu(menuItem);
        Thread::wait(100);
    }
}


/**
 * Display a message on the LCD screen prefixed with IBM IoT Cloud
 */

/*void displayMessage(char* message)
{
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("IBM IoT Cloud");
    lcd.locate(0,16);
    lcd.printf(message);
}*/


int connect(MQTT::Client<MQTTEthernet, Countdown, MQTT_MAX_PACKET_SIZE>* client, MQTTEthernet* ipstack)
{
    const char* iot_ibm = ".messaging.internetofthings.ibmcloud.com";

    char hostname[strlen(org) + strlen(iot_ibm) + 1];
    sprintf(hostname, "%s%s", org, iot_ibm);
    EthernetInterface& eth = ipstack->getEth();
    ip_addr = eth.getIPAddress();
    gateway_addr = eth.getGateway();

    // Construct clientId - d:org:type:id
    char clientId[strlen(org) + strlen(type) + strlen(id) + 5];
    sprintf(clientId, "d:%s:%s:%s", org, type, id);

    // Network debug statements
    LOG("=====================================\n");
    LOG("Connecting Ethernet.\n");
    LOG("IP ADDRESS: %s\n", eth.getIPAddress());
    LOG("MAC ADDRESS: %s\n", eth.getMACAddress());
    LOG("Gateway: %s\n", eth.getGateway());
    LOG("Network Mask: %s\n", eth.getNetworkMask());
    LOG("Server Hostname: %s\n", hostname);
    LOG("Client ID: %s\n", clientId);
    LOG("=====================================\n");

    netConnecting = true;
    int rc = ipstack->connect(hostname, IBM_IOT_PORT, connectTimeout);
    if (rc != 0) {
        WARN("IP Stack connect returned: %d\n", rc);
        return rc;
    }
    netConnected = true;
    netConnecting = false;

    // MQTT Connect
    mqttConnecting = true;
    MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
    data.MQTTVersion = 3;
    data.clientID.cstring = clientId;

    if (!quickstartMode) {
        data.username.cstring = "use-token-auth";
        data.password.cstring = auth_token;
    }

    if ((rc = client->connect(data)) == 0) {
        connected = true;
        green();
        //displayMessage("Connected");
        wait(1);
        //displayMessage("Scroll with joystick");
    } else
        WARN("MQTT connect returned %d\n", rc);
    if (rc >= 0)
        connack_rc = rc;
    mqttConnecting = false;
    return rc;
}


int getConnTimeout(int attemptNumber)
{
    // First 10 attempts try within 3 seconds, next 10 attempts retry after every 1 minute
    // after 20 attempts, retry every 10 minutes
    return (attemptNumber < 10) ? 3 : (attemptNumber < 20) ? 60 : 600;
}


void attemptConnect(MQTT::Client<MQTTEthernet, Countdown, MQTT_MAX_PACKET_SIZE>* client, MQTTEthernet* ipstack)
{
    connected = false;

    // make sure a cable is connected before starting to connect
    while (!linkStatus()) {
        wait(1.0f);
        WARN("Ethernet link not present. Check cable connection\n");
    }

    while (connect(client, ipstack) != MQTT_CONNECTION_ACCEPTED) {
        if (connack_rc == MQTT_NOT_AUTHORIZED || connack_rc == MQTT_BAD_USERNAME_OR_PASSWORD)
            return; // don't reattempt to connect if credentials are wrong

        Thread red_thread(flashing_red);

        int timeout = getConnTimeout(++retryAttempt);
        WARN("Retry attempt number %d waiting %d\n", retryAttempt, timeout);

        // if ipstack and client were on the heap we could deconstruct and goto a label where they are constructed
        //  or maybe just add the proper members to do this disconnect and call attemptConnect(...)

        // this works - reset the system when the retry count gets to a threshold
        if (retryAttempt == 5)
            NVIC_SystemReset();
        else
            wait(timeout);
    }
}


int publish(MQTT::Client<MQTTEthernet, Countdown, MQTT_MAX_PACKET_SIZE>* client, MQTTEthernet* ipstack)
{
    MQTT::Message message;
    char* pubTopic = "iot-2/evt/status/fmt/json";

    char buf[250];
    /*printf(buf,
      "{\"d\":{\"myName\":\"IoT mbed\",\"accelX\":%0.4f,\"accelY\":%0.4f,\"accelZ\":%0.4f,\"temp\":%0.4f,\"joystick\":\"%s\",\"potentiometer1\":%0.4f,\"potentiometer2\":%0.4f,\"badge\":\"%s\"}}",
             0.5, 0.5, 0.5,0.5,RFID, 0.5, 0.5,RFID_str);*/

    sprintf(buf,"{\"d\":{\"myName\":\"IoT mbed\",\"key\":\"%s\"}}",RFID_old);
    message.qos = MQTT::QOS0;
    message.retained = false;
    message.dup = false;
    message.payload = (void*)buf;
    message.payloadlen = strlen(buf);

    LOG("Publishing %s\n", buf);
    return client->publish(pubTopic, message);
}


char* getMac(EthernetInterface& eth, char* buf, int buflen)    // Obtain MAC address
{
    strncpy(buf, eth.getMACAddress(), buflen);

    char* pos;                                                 // Remove colons from mac address
    while ((pos = strchr(buf, ':')) != NULL)
        memmove(pos, pos + 1, strlen(pos) + 1);
    return buf;
}


void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    char topic[md.topicName.lenstring.len + 1];

    sprintf(topic, "%.*s", md.topicName.lenstring.len, md.topicName.lenstring.data);

    LOG("Message arrived on topic %s: %.*s\n",  topic, message.payloadlen, message.payload);
    
    // Command topic: iot-2/cmd/blink/fmt/json - cmd is the string between cmd/ and /fmt/
    char* start = strstr(topic, "/cmd/") + 5;
    int len = strstr(topic, "/fmt/") - start;

    if (memcmp(start, "blink", len) == 0) {
        char payload[message.payloadlen + 1];
        sprintf(payload, "%.*s", message.payloadlen, (char*)message.payload);
        

        char* pos = strchr(payload, '}');
        if (pos != NULL) {
            *pos = '\0';
            if ((pos = strchr(payload, ':')) != NULL) {
                int blink_rate = atoi(pos + 1);
                blink_interval = blink_rate;
            }
        }
    } else
        WARN("Unsupported command: %.*s\n", len, start);
}


int main()
{
    RfChip.PCD_Init();
    quickstartMode = (strcmp(org, "quickstart") == 0);

    //lcd.set_font((unsigned char*) Arial12x12);  // Set a nice font for the LCD screen

    led2 = LED2_OFF; // K64F: turn off the main board LED

    //displayMessage("Connecting");
    
    Thread yellow_thread(flashing_yellow);
    Thread menu_thread(menu_loop);
    Thread tag_thread(tagRFID);

    LOG("***** IBM IoT Client Ethernet Example *****\n");
    MQTTEthernet ipstack;
    ethernetInitialising = false;
    MQTT::Client<MQTTEthernet, Countdown, MQTT_MAX_PACKET_SIZE> client(ipstack);
    LOG("Ethernet Initialized\n");

    if (quickstartMode)
        getMac(ipstack.getEth(), id, sizeof(id));

    attemptConnect(&client, &ipstack);

    if (connack_rc == MQTT_NOT_AUTHORIZED || connack_rc == MQTT_BAD_USERNAME_OR_PASSWORD) {
        red();
        while (true)
            wait(1.0); // Permanent failures - don't retry
    }

    if (!quickstartMode) {
        int rc = 0;
        if ((rc = client.subscribe("iot-2/cmd/+/fmt/json", MQTT::QOS1, messageArrived)) != 0)
            WARN("rc from MQTT subscribe is %d\n", rc);
    }

    blink_interval = 0;
    int count = 0;
    while (true) {
        if (true) {
              client.yield(100);  // allow the MQTT client to receive messages
            // Publish a message every second
            /*if ( ! RfChip.PICC_IsNewCardPresent()) {
                wait_ms(100);
                continue;
            }

            if ( ! RfChip.PICC_ReadCardSerial()) {
                wait_ms(100);
                continue;
            }*/

            //LedGreen = 0;
            // Print Card UID
            //intf("Card UID: ");
            //char* RFID_str = (char*) malloc (2*RfChip.uid.size + 1);
           /* char* RFID_ptr = RFID_str;
            for (uint8_t i = 0; i < RfChip.uid.size; i++) {
                printf("%2X", RfChip.uid.uidByte[i]);
                RFID_ptr += sprintf(RFID_ptr, "%02X", RfChip.uid.uidByte[i]);
            }*/
            
            //sprintf(RFID_str,"%02X%02X%02X%02X",RfChip.uid.uidByte[0],RfChip.uid.uidByte[1],RfChip.uid.uidByte[2],RfChip.uid.uidByte[3]);
            /*
            sprintf(RFID_ptr,"\n\t");
            *(RFID_ptr + 1) = '\0';
            //printf("badge no : %s\n", RFID_str);
            printf("\n");
            //RFID2 = RFID_str;
            */
            // Print Card type
            //uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak);
            //printf("PICC Type: %s \n\r", RfChip.PICC_GetTypeName(piccType));
            
            wait_ms(100);
            
            //if(New_RFID == true )
            //{
                if (publish(&client, &ipstack) != 0)
                attemptConnect(&client, &ipstack);   // if we have lost the connection
                count = 0;
            
                /*if (blink_interval == 1)
                {
                        if (  RfChip.PICC_IsNewCardPresent()) {led2.write(1);}
                        else
                            {led2.write(0);}
                }
                else 
                    {led2.write(0);}*/
                //}
            
           // client.yield(100);  // allow the MQTT client to receive messages

            //LedGreen = 1;

            //Partie RFID
            //
            // Look for new cards


            // Select one of the cards
        }
    }
}


