/* mbed Microcontroller Library
 * Copyright (c) 2019 ARM Limited
 * SPDX-License-Identifier: Apache-2.0
 */

#include "mbed.h"
#include "platform/mbed_thread.h"
#include "LCD.h"

/*
Bei mir: 
PC_7 Fussgänger grün
PC_6 Fußgänger rot  FG rot:0b01
PC_5 auto1 gelb
PC_4 auto1 grün
PC_3 auto1 rot  =>FG rot, auto1 rot :0b01 001
PC_2 auto2 gelb  1
PC_1 auto2 grün  0
PC_0 auto2 rot   1  =>FG rot, auto1 rot, auto2 rot :0b01 001 001
*/
#define rotrotrot 0b01001001  //FG rot, auto1 rot, auto2 rot :0b01 001 001
#define rotrotorange 0b01001101  //FG rot, auto1 rot, auto2 rotgelb :0b01 001 101
#define rotrotgruen 0b01001010  //FG rot, auto1 rot, auto2 gruen :0b01 001 101
#define rotrotgelb 0b01001100  //FG rot, auto1 rot, auto2 gelb :0b01 001 101
#define rotorangerot 0b01101001  //FG rot, auto1 rot, auto2 rotgelb :0b01 001 101
#define rotgruenrot 0b01010001  //FG rot, auto1 rot, auto2 gruen :0b01 001 101
#define rotgelbrot 0b01010001  //FG rot, auto1 rot, auto2 gelb :0b01 001 101
#define gruenrotgelb 0b10001001  //FG grün, auto1 rot, auto2 rot :0b01 001 001


//1. Deklarieren global
//Wir legen fest: 
// a) welche Anschlüsse sollen verwendet werden
// b) den Namen der Anschlüsse im Programm
// c) die Richtung Eingänge oder Ausgänge
PortOut anzeige(PortC,0b11111111); 

lcd mylcd;

AnalogIn poti(PA_0);

int main()
{
    // Initialise the digital pin LED1 as an output
    DigitalOut led(LED1);
    DigitalIn taste(PA_1);
    taste.mode(PullDown); //bei nicht betätigt taste=0 (inaktiv)
    mylcd.clear();
    
    while (true) {
        led = !led;

        anzeige=rotrotrot;
        mylcd.cursorpos(0);
        mylcd.printf("rot rot rot    ");
        thread_sleep_for(poti*1000);
        anzeige=rotrotorange;
        mylcd.cursorpos(0);
        mylcd.printf("rot rot orange ");
        thread_sleep_for(poti*1000);
        anzeige=rotrotgruen;
        mylcd.cursorpos(0);
        mylcd.printf("rot rot gruen  ");
        thread_sleep_for(poti*1000);
        anzeige=rotrotgelb;
        mylcd.cursorpos(0);
        mylcd.printf("rot rot gelb   ");
        thread_sleep_for(poti*1000);
        anzeige=rotrotrot;
        mylcd.cursorpos(0);
        mylcd.printf("rot rot rot    ");
        thread_sleep_for(poti*1000);
        anzeige=rotorangerot;
        mylcd.cursorpos(0);
        mylcd.printf("rot orange rot ");
        thread_sleep_for(poti*1000);
        anzeige=rotgruenrot;
        mylcd.cursorpos(0);
        mylcd.printf("rot gruen rot  ");
        thread_sleep_for(poti*1000);
        anzeige=rotgelbrot;
        mylcd.cursorpos(0);
        mylcd.printf("rot gelb rot   ");
        thread_sleep_for(poti*1000);
        if (taste==1)
        {
            anzeige=gruenrotgelb;
            mylcd.cursorpos(0);
            mylcd.printf("gruen rot gelb   ");
            thread_sleep_for(poti*1000);
        }
    }
}
