
//based on DHT11 Library of Jeng: https://os.mbed.com/users/JENG/code/Nucleo_dht11/
#include "mbed.h"
#include "LCD.h"
#include "ESP8266Webserver.h"


#define DHTLIB_OK                0
#define DHTLIB_ERROR_CHECKSUM   -1
#define DHTLIB_ERROR_TIMEOUT    -2
ESP8266Webserver myWebserver;
Timer tmr;
lcd mylcd;

DigitalInOut data_pin(PB_0);  //Anschluss S (Data)
//Anschluss - an GND
//mittlerer Anschluss an 3,3V

int humidity;
int temperature;

//########################################
// DHT11 Library
//########################################
int dht_read(void){
    
    // BUFFER TO RECEIVE
    uint8_t bits[5];
    uint8_t cnt = 7;
    uint8_t idx = 0;
    
    tmr.stop();
    tmr.reset();

    // EMPTY BUFFER
    for(int i=0; i< 5; i++) bits[i] = 0;

    // REQUEST SAMPLE
    data_pin.output();
    data_pin.write(0);
    wait_us(18000);
    data_pin.write(1);
    wait_us(40);
    data_pin.input();

    // ACKNOWLEDGE or TIMEOUT
    unsigned int loopCnt = 20000;
    
    while(!data_pin.read())if(!loopCnt--)return DHTLIB_ERROR_TIMEOUT;

    loopCnt = 20000;
    
    while(data_pin.read())if(!loopCnt--)return DHTLIB_ERROR_TIMEOUT;

    // READ OUTPUT - 40 BITS => 5 BYTES or TIMEOUT
    for(int i=0; i<40; i++){
        
        loopCnt = 20000;
        
        while(!data_pin.read())if(loopCnt-- == 0)return DHTLIB_ERROR_TIMEOUT;

        //unsigned long t = micros();
        tmr.start();

        loopCnt = 20000;
        
        while(data_pin.read())if(!loopCnt--)return DHTLIB_ERROR_TIMEOUT;

        if(tmr.read_us() > 40) bits[idx] |= (1 << cnt);
        
        tmr.stop();
        tmr.reset();
        
        if(cnt == 0){   // next byte?
        
            cnt = 7;    // restart at MSB
            idx++;      // next byte!
            
        }else cnt--;
        
    }

    // WRITE TO RIGHT VARS
    // as bits[1] and bits[3] are allways zero they are omitted in formulas.
    humidity    = bits[0]; 
    temperature = bits[2]; 

    uint8_t sum = bits[0] + bits[2];  

    if(bits[4] != sum)return DHTLIB_ERROR_CHECKSUM;
    
    return DHTLIB_OK;
    
}

char buffer[17];

//########################################
// End of DHT11 Library
//########################################
float poti=0.5;
string getRootPage()
{
      string webpage;
      webpage="<!DOCTYPE html>";
      //Javascript
      webpage+="<script type=\"text/javascript\">";
      webpage+="var x;";
      webpage+="function z(){location.assign(\"http://";
      webpage+=myWebserver.gibIP();
      webpage+="\");}";
      webpage+="function sT(){x=setInterval(z,1000);}";
      webpage+="function spT(){clearInterval(x);}";
      webpage+="onload=sT();";
      webpage+="</script>\n";
      //HTML
      webpage+="<html>";
      webpage+="<head>";
      webpage+="<title>STM32 HTTP</title>";
      webpage+="</head>";
      webpage+="<body>";
      webpage+="<h1>WIFI mit STM32 ESP01</h1>\n";
      webpage+="<p>Tmp:"+to_string(temperature)+" C</p>\n"; 
      webpage+="<p>Hum:"+to_string(humidity)+"%</p>\n"; 
      webpage+="</body>";
      webpage+="</html>";
      return webpage;
}


void testfunc()
{
    myWebserver.send(200,"text/html",getRootPage());
}


int main(void){
    myWebserver.on("/",&testfunc);
    myWebserver.begin();    
    mylcd.clear();
    mylcd.cursorpos(0);
    
    mylcd.printf("Nucleo - DHT11");
    
    for(;;){
       myWebserver.handleClient();
       int fehler=dht_read();
        
            

            mylcd.cursorpos(0x40);
            mylcd.printf("Hum %2d%%  Tmp %2dc  ", humidity, temperature);
            wait_us(500000);
            

    
    }
    
}
