/*
 * Copyright (c) 2017, Arm Limited and affiliates.
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifdef TARGET_UBLOX_C030_R41XM

#include "UbloxATCmdParser.h"
#include "rtos/Thread.h"

using namespace mbed;

UbloxATCmdParser::UbloxATCmdParser(FileHandle *fh, const char *output_delimiter, int buffer_size, int timeout, bool debug) : ATCmdParser(fh, output_delimiter, buffer_size, timeout, debug)
{
    idle_mode_disabled();
}
UbloxATCmdParser::~UbloxATCmdParser()
{

}


bool UbloxATCmdParser::send(const char *command, ...)
{
    bool status = false;

    if (_idle_mode_status == true) { //idle mode is active
        if ( _wakeup_timer.read_ms() >= 5000) { //if more than 5 secs have passed since last TX activity, wake up the modem.
            uint8_t retries = 3;
            ATCmdParser::set_timeout(1000);
            while(retries--) {
                ATCmdParser::putc('A');
                ThisThread::sleep_for(10); //wait a little
                if ( (ATCmdParser::send("AT")) && (ATCmdParser::recv("OK")) ) { //check if modem is awake and accepting commands
                    status = true;
                    break;
                }
            }
            ATCmdParser::set_timeout(_timeout);
            if (status == false) { //all tries failed, return false
                _wakeup_timer.reset();
                return status;
            }
        }
        _wakeup_timer.reset(); //Any activity on tx will reset the timer. Timer will expire if no activity since last 5 secs
    }

    va_list args;
    va_start(args, command);
    status = ATCmdParser::vsend(command, args);
    va_end(args);
    return status;
}

void UbloxATCmdParser::idle_mode_enabled()
{
    _idle_mode_status = true;
    _wakeup_timer.start();
}

void UbloxATCmdParser::idle_mode_disabled()
{
    _idle_mode_status = false;
    _wakeup_timer.stop();
}

bool UbloxATCmdParser::is_idle_mode_enabled()
{
	return _idle_mode_status;
}

void UbloxATCmdParser::set_timeout(int timeout) {
    _timeout = timeout;
    ATCmdParser::set_timeout(timeout);
}
#endif /* TARGET_UBLOX_C030_R41XM */
