/*
 * Copyright (c) 2017, Arm Limited and affiliates.
 * SPDX-License-Identifier: Apache-2.0
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifdef TARGET_UBLOX_C030_R41XM
#ifndef UBLOXATCMDPARSER_H_
#define UBLOXATCMDPARSER_H_

#include "ATCmdParser.h"
#include "mbed.h"

namespace mbed {

/**
 *  Class UbloxATCmdParser
 *
 */
class UbloxATCmdParser : public ATCmdParser
{
public:
    UbloxATCmdParser(FileHandle *fh, const char *output_delimiter = "\r",
             int buffer_size = 256, int timeout = 8000, bool debug = false);
    ~UbloxATCmdParser();

    bool send(const char *command, ...) MBED_PRINTF_METHOD(1,2);

    void set_timeout(int timeout);

    bool is_idle_mode_enabled();

	void idle_mode_enabled();

    void idle_mode_disabled();
	
private:
    bool _idle_mode_status;
    Timer _wakeup_timer;
    int _timeout;
};


} // namespace mbed

#endif
#endif

