/* mbed Microcontroller Library
 * Copyright (c) 2017 u-blox
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#include "mbed.h"
#include "UbloxATCellularInterface.h"


// INTERFACE_CLASS *interface = new INTERFACE_CLASS();
// If you need to debug the cellular interface, comment out the
// instantiation above and uncomment the one below.
// For the N2xx interface, change xxx to MBED_CONF_UBLOX_CELL_BAUD_RATE,
// while for the non-N2xx interface change it to MBED_CONF_UBLOX_CELL_N2XX_BAUD_RATE
UbloxATCellularInterface *interface = new UbloxATCellularInterface(MDMTXD, MDMRXD, 115200, false);

// LEDs
DigitalOut ledRed(LED1, 1);
DigitalOut ledGreen(LED2, 1);
DigitalOut ledBlue(LED3, 1);

void swap(char* a, char* b)
{
    char c;

    c = *a;
    *a = *b;
    *b = c;
}

void csim_read_imsi(char* imsi)
{
    char response[20], SW1[3], SW2[3];

    if (interface->csim_select_file(14, "00A40000023F00")) {
        if (interface->csim_select_file(14, "00A40000027F20")) {
            if (interface->csim_select_file(14, "00A40000026F07")) {
                int len = interface->csim_read_file(10, "00B0000009", response, SW1, SW2);
                if (strcmp(SW1 , "90") == 0 && strcmp(SW2 , "00") == 0) {
                    for (int a = 2; a < len - 4; a = a + 2) {
                    	swap(&response[a], &response[a+1]);
                    }
                    memcpy(imsi, response+3, 15);
                    imsi[15] = '\0';
                }
            }
        }
    }
}

void csim_read_iccid(char* iccid)
{
    char response[25], SW1[3], SW2[3];

    if (interface->csim_select_file(14, "00A40000023F00")) {
        if (interface->csim_select_file(14, "00A40000022FE2")) {
            int len = interface->csim_read_file(10, "00B0000010", response, SW1, SW2);
            if (strcmp(SW1 , "90") == 0 && strcmp(SW2 , "00") == 0) {
                for (int a = 0; a < len - 4; a = a + 2) {
                    swap(&response[a], &response[a+1]);
                }
                memcpy(iccid, response, 19);
                iccid[20] = '\0';
            }
        }
    }
}

int main()
{
    printf("\r\nu-blox C030 U201 and R412M reading the modem IMSI and ICCID using CSIM\n\r\n\r");

    char imsi[20], iccid[20];

    interface->init();

    csim_read_imsi(imsi);
    printf("IMSI = %s \r\n\r\n", imsi);

    csim_read_iccid(iccid);
    printf("ICCID = %s \r\n", iccid);


    // Set the LED states
    ledRed = 0;
    ledGreen = 1;
    ledBlue = 1;

    // Main loop
    while(1) {
        wait(1);
        // Shift the LED states
        int carry = ledBlue;
        ledBlue = ledRed;
        ledRed = ledGreen;
        ledGreen = carry;
    }
}
// End Of File
