/* mbed Microcontroller Library
 * Copyright (c) 2017 u-blox
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "mbed.h"
#include "gnss.h"
#include "battery_charger_bq24295.h"
#include "onboard_modem_api.h"

// Set the minimum input voltage limit for the BQ24295 to 3.8 Volt
#define MIN_INPUT_VOLTAGE_LIMIT_MV  3880

// User LEDs
DigitalOut ledRed(LED1, 1);
DigitalOut ledGreen(LED2, 1);
DigitalOut ledBlue(LED3, 1);

//GNSS 1V8_MAX IO power
DigitalOut GNSSOn(GNSSEN, 1);

// Ethernet socket LED 
DigitalOut ledYellow(LED4,1);

// User Button
#ifdef TARGET_UBLOX_C027
    // No user button on C027
    InterruptIn userButton(NC);
#else
    InterruptIn userButton(SW0);
#endif

// GNSS
GnssSerial gnss;

// i2c3 Bus
I2C i2c3(I2C_SDA_B, I2C_SCL_B);
    
// Battery Charger BQ24295
BatteryChargerBq24295 charger;

// Delay between LED changes in second
volatile float delay = 0.5;

// To check if the user pressed the User Button or not
void threadBodyUserButtonCheck(void const *args){
    while (1){
        if (userButton.read() == 1 ) {
        // User Button is pressed 
            delay = 0.1;
            //Indicate the button is pressed 
            ledYellow = 0;
        }
        else { 
        // User button is released
            delay = 0.5;
            //Turn off the Yellow LED on Ethernet socket
            ledYellow = 1;
        }
    }
}

/*
** Out of the Box Demo for C030 variants
** 
** Sets the modem then    
*/

int main()
{
    printf("u-blox C030 Out-of-the-Box Demo\n\r");

    // GNSS initialisation
    if(gnss.init()) {
        printf("GNSS initialised.\n\r");
    }
    else {
        printf("GNSS initialisation failure.\n\r");
    }
   
    // The battery charger initialisation
    charger.init(&i2c3);   
    charger.setInputVoltageLimit(MIN_INPUT_VOLTAGE_LIMIT_MV); 
    // Disable the battery charger's watchdog, otherwise it resets the battry charger
    charger.setWatchdog(0);
   
    // Initialised the modem
    onboard_modem_init();
    
    // Power up the modem
    onboard_modem_power_up();
    
    // Create threadUserButtonCheck thread
    Thread user_button(osPriorityNormal);
    user_button.start(callback(threadBodyUserButtonCheck, (void *)"User Button Thread"));

    
    //Set GNSS IO On
    GNSSOn = 1;
    
    // Set the LED states
    ledRed = 0;
    ledGreen = 1;
    ledBlue = 1;
    
    printf("u-blox C030 Out-of-the-Box Demo: LED loop\n\r");
    
    //Main loop
    while(1) {
        wait(delay);
        //Shift the LED states
        int carry = ledBlue;
        ledBlue = ledRed;
        ledRed = ledGreen;
        ledGreen = carry;
    }
}

// End Of File