/*                                        Cyclic Executive
This software is built to test (Cyclic Executive). 6 main tasks are used in and every one of them
has its own time of repetition. To execute this, a Ticker was used to call a function every 4 mSec.
In this software a benefit is a token from two counter, one is counting a pulses and it reset every 25 cycles.
That mean it reset every 100 mSec. Then other counter (AllTimeCounter that count a 100 mSec) increased by one.
A slot is defined for each function, for example the slot number 1 is to reading the two digital input. however
this slote is for this function it is not excuted every slot 1. It is excuted just when the timer calculat 400 mSec. 
That is 100 cycles. Also, after 200 cycles (800 mSec) the condition is true for two factions, but the processor will 
implement one in slot 1 and next cycle implement the other. Excuting the LCD and writing file got more slote space.
The LCD show slot is 72 mSec and the writing is 8 mSec. At A Sec 180 all functions are called and the 1800 (100 mSec)
will be like this:
   __    __    __    __    __    __    __    __    __                        __  
  |  |  |  |  |  |  |  |  |  |  |  |  |  |  |  |  |  |                      |  |  
  |  |  |  |  |  |  |  |  |  |  |  |  |  |  |  |  |  |----------------------|  | 
__|  |__|  |__|  |__|  |__|  |__|  |__|  |__|  |__|  |__                  __|  |__ 
   <S1 > < S2> <     S3  > < S4> < S5> <    S6   > <              S7             >
    
     4     4       8        4     4        8                   64    mSec 
    ___   ___   ________   ___   ___   ________    __                       __  
   |   | |   | |        | |   | |   | |        |  |                        |  |  
   |   | |   | |        | |   | |   | |        |  |  ----------------------|  | 
 __|   |_|   |_|        |_|   |_|   |_|        |__|                      __|  |__     
   
        The full program ducimentation is on
        http://mbed.org/users/muaiyd/code/ass2/
*/
#include "Function.h"
#include "Display.h"
#include "FreqMesure.h"
#include "ReadInput.h"

uint16_t Counter = 0;
uint16_t AllTimeCounter = 1; //It start from 1 to avoid excute all function at begining

void CycleFunction(); 
 
int main(){
    Init_LCD();
    InitFile();
    LogTimer.start();
    Cycle.attach_us(&CycleFunction,4000);      
}

void CycleFunction(){

/*
    We can see the period of execute time for  every function below on the pin that
    assigned for each and writen infront of it.    The least common multiple for all the above
     repeat time function is 180 Sec so every 180 Sec all the cycle is repeated. That mean 45000
     cycles.
*/
   
    Counter ++ ;
    switch(Counter){
        case 1:
            if( AllTimeCounter % 4 == 0) ReadDigitalin();  //Pin 21      
        break;
        case 2:
            if( AllTimeCounter % 8 ==0) ReadAnalogin();   //Pin 22
        break;
        case 3:
            if( AllTimeCounter % 10 == 0) FreqMsur();     //Pin 23
        break;
        case 5:
            if( AllTimeCounter % 15 == 0) BinaryCounter();//Pin 24
        break;
        case 6:
            if( AllTimeCounter % 18 == 0) InputCheck();   //Pin 25
        break;
        case 7:
            if( AllTimeCounter % 50 == 0 ) LogFile();      //Pin 27
        break;
        case 9:
            if( AllTimeCounter % 20 == 0 ) Display();      //Pin 26
        break;
        case 25:
            Counter = 0;
            AllTimeCounter ++ ;
            TickerPin = !(TickerPin);
        break;
    }
    if ( AllTimeCounter == 1800 ) AllTimeCounter = 0; 
}