#include "MCP23017.h"
#include "WattBob_TextLCD.h"
#include "mbed.h"
#include "SDFileSystem.h"

MCP23017 Port(p9,p10,0x40) ;      // 16-bit object with I2C Chip MCP23017 
WattBob_TextLCD LCD(&Port);       // A 2*16 chacater LCD object


BusOut BinLed(LED4, LED3, LED2, LED1);

DigitalIn FrequencyIn(p15);
DigitalIn Switch1(p17);
DigitalIn Switch2(p18);
/*
  These pins are used to show the time between every execution.
Because of the execution time is very small I used the pins to flip 
high and low with every time the functions are called. Consequently,
the period of high or of low represent the complete time.

*/
DigitalOut TickerPin(p30);

DigitalOut ReadDigitalinPin(p21);
DigitalOut ReadAnaloginPin(p22);
DigitalOut FreqMsurPin(p23);
DigitalOut BinaryCounterPin(p24);
DigitalOut InputCheckPin(p25);
DigitalOut DisplayPin(p26);
DigitalOut LogFilePin(p27);


AnalogIn Analogue_in_1(p19);
AnalogIn Analogue_in_2(p20);
 
SDFileSystem sd(p5, p6, p7, p8, "sd"); // the pinout on the mbed Cool Components workshop board

uint8_t Analug1_valu[5]={0,0,0,0,0};
uint8_t Analug2_valu[5]={0,0,0,0,0};
uint8_t Bin=0x00;
bool Swch1;
bool Swch2;
bool Ena_BinCounter=0;
bool FreqTimeOutHpn;
uint8_t Error_Code;
uint16_t Freq;
char Temp[4];
FILE *fp;

Timer FreqMsurT;
Timer FreqTimeOut;
Timer LogTimer;

Ticker Cycle;

void Init_LCD();
void FreqMsur();
void ReadDigitalin();
void ReadAnalogin();
void Display();
void InputCheck();
void BinaryCounter();
void InitFile();
void LogFile();

/******************************************************************************
        Small function to writ on the LCD with one instruction
********************************************************************************/
void Write_LCD(const char STR[],int8_t PY,int8_t PX,bool clr){
    if(clr)
        LCD.cls();
    LCD.locate(PY,PX);
    LCD.printf(STR);
}
/**************************************************************************
                Intialise the LCD to be ready to writ on
***************************************************************************/
void Init_LCD(){
    Port.write_bit(1,BL_BIT);
    Write_LCD("F=",0,0,1);
    Write_LCD("A1=",1,0,0);
    Write_LCD("A2=",1,7,0);
    Write_LCD("S1=",0,7,0);
    Write_LCD("S2=",0,12,0);
    Write_LCD("E",1,14,0);
}

/*************************************************************************
                Cheaking the four input every 1.8 Sec
************************************************************************/
void InputCheck(){
    InputCheckPin = ! (InputCheckPin);    //Pin 25
    if(Swch1&&(Analug1_valu[4]>Analug2_valu[4])){
        Error_Code=3;
    }
    else{
        Error_Code=0;
    }
    if(Swch2){
        Ena_BinCounter=1;
    }
    else{
        Ena_BinCounter=0;
    }        
}

/***************************************************************
              Initialising the SD card file
*****************************************************************/
void InitFile(){
    fp = fopen( "/sd/LogDir/LogHistory.csv" , "a");
    if(fp == NULL) {
        Write_LCD("SD Card Error",0,0,1);
        Write_LCD("Try Reset",1,0,0);
    } 
    fprintf(fp,"Time;Freq;Sw1;Sw2;An1;An2\r\n");
    fclose(fp);  
}
/**************************************************************
        Saving the flowing data in a file
        a. Frequency value 
        b. digital input values 
        c. Filtered analogue values
***************************************************************/
void LogFile(){ 
    LogFilePin = ! (LogFilePin);         //Pin 27
    fp = fopen( "/sd/LogDir/LogHistory.csv" , "a"); 
    fprintf(fp,"%i;",(LogTimer.read_ms()/1000));
    if (Freq !=0xffff){
        fprintf(fp,"%4i;",Freq);
    }
    else{
        fprintf(fp,"%4s;","Err");
    }
    fprintf(fp,"%i;",Swch1);
    fprintf(fp,"%i;",Swch2);
    fprintf(fp,"%3d;",Analug1_valu[4]);
    fprintf(fp,"%3d;",Analug2_valu[4]);
    fprintf(fp,"%s","\r\n");
    fclose(fp);
    //LogFilePin = ! (LogFilePin);     
}