/***********************************
*              CAR.h               *
************************************/
#ifndef CAR_H
#define CAR_H
#include "rtos.h"
#include "CommonVariable.h"

    typedef struct {
            uint8_t Mail_Average_Speed; 
            float   Mail_Accelerometer_Value;
            float   Mail_Brake_Value;
            int     Counter;
    } CAR_MAIL;
     
class CAR {
    public:
        CAR();
        static void SAVE_ODO(float value);
        static float GET_ODO();
        
        static void Car_Simulation(void const *args);
        static uint8_t Measure_Speed();
        static void Average_Speed_Measure(void const *args);
        static void Average_Speed_Show(void const *args);
        static void OverSpeed(void const *args);
        static void Odo_Show(void const *args);
        static void SEND_CAR_VALUES (void const *args);
        static void DUMP_CAR_VALUES_En (void const *args);
        static void DUMP_CAR_VALUES();
        static void Side_Light_Flash(void const *args);
        static void Side_Light(void const *args);
        
};

#endif