/***********************************
*       CommonVariable.h           *
************************************/
#ifndef COMMON_VARIABLE_H
#define COMMON_VARIABLE_H
#include "MCP23017.h"
#include "WattBob_TextLCD.h"
#include "mbed.h"
#include "Servo.h"

static Servo SpeedShow_Servo(p21); // Use pin 21 to control the servo
static MCP23017 Port(p9,p10,0x40) ;      // 16-bit object with I2C Chip MCP23017 
static WattBob_TextLCD LCD(&Port);       // A 2*16 chacater LCD object
//Input and Output ports
static BusOut OverSpeedLED(LED1 , LED2 , LED3 , LED4);
static DigitalIn EngineSwitch(p5);
static DigitalOut R_Side_Light(p27);
static DigitalOut L_Side_Light(p28);
static DigitalOut R_Side_Indicator(p29);
static DigitalOut L_Side_Indicator(p30);
static DigitalIn L_Light_Switch(p6);
static DigitalIn R_Light_Switch(p7);
static DigitalIn L_Indicator_Switch(p15);
static DigitalIn R_Indicator_Switch(p16);
static AnalogIn Accelerometer(p19);
static AnalogIn Brake(p20);

extern const uint8_t MaxSpeed;
//Inpout Data Variable
extern bool EngineStat;
extern bool IsOverSpeed;
extern bool R_LightSide_SW;
extern bool L_LightSide_SW;
extern bool R_Indicator_SW;
extern bool L_Indicator_SW;
extern float Accelerometer_Value;
extern float Brake_Value;

extern uint8_t Speed[3];
extern uint8_t Average_Speed;
extern float Odometer_Value;
extern uint8_t Counter;

#endif